/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.mock.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.seasar.extension.mock.servlet.MockHeaderUtil;
import org.seasar.extension.mock.servlet.MockHttpSession;
import org.seasar.extension.mock.servlet.MockRequestDispatcher;
import org.seasar.framework.util.EmptyEnumeration;
import org.seasar.framework.util.EnumerationAdapter;

public class MockHttpServletRequest
implements HttpServletRequest {
    private ServletContext servletContext_;
    private String servletPath_;
    private String authType_;
    private List cookieList = new ArrayList();
    private Map headers_ = new HashMap();
    private String method_ = "POST";
    private String pathInfo_;
    private String pathTranslated_;
    private String queryString_;
    private MockHttpSession session_;
    private String scheme_ = "http";
    private int serverPort_ = 80;
    private String protocol_ = "HTTP/1.1";
    private String serverName_ = "localhost";
    private Map attributes_ = new HashMap();
    private String characterEncoding_ = "ISO-8859-1";
    private int contentLength_;
    private String contentType_;
    private Map parameters_ = new HashMap();
    private String remoteAddr_;
    private String remoteHost_;
    private Locale locale_;

    public MockHttpServletRequest(ServletContext servletContext, String servletPath) {
        this.servletContext_ = servletContext;
        this.servletPath_ = servletPath.charAt(0) == '/' ? servletPath : "/" + servletPath;
    }

    public String getAuthType() {
        return this.authType_;
    }

    public void setAuthType(String authType) {
        this.authType_ = authType;
    }

    public Cookie[] getCookies() {
        return this.cookieList.toArray(new Cookie[this.cookieList.size()]);
    }

    public void addCookie(Cookie cookie) {
        this.cookieList.add(cookie);
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        return MockHeaderUtil.getDateValue(value);
    }

    public String getHeader(String name) {
        List values = this.getHeaderList(name);
        if (values != null) {
            return (String)values.get(0);
        }
        return null;
    }

    public Enumeration getHeaders(String name) {
        List values = this.getHeaderList(name);
        if (values != null) {
            return new EnumerationAdapter(values.iterator());
        }
        return new EmptyEnumeration();
    }

    public Enumeration getHeaderNames() {
        return new EnumerationAdapter(this.headers_.keySet().iterator());
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        return MockHeaderUtil.getIntValue(value);
    }

    public void addHeader(String name, String value) {
        ArrayList<String> values = this.getHeaderList(name);
        if (values == null) {
            values = new ArrayList<String>();
        }
        values.add(value);
        this.headers_.put(name.toLowerCase(), values);
    }

    public void addDateHeader(String name, long value) {
        this.addHeader(name, MockHeaderUtil.getDateValue(value));
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, "" + value);
    }

    private List getHeaderList(String name) {
        name = name.toLowerCase();
        return (List)this.headers_.get(name);
    }

    public String getMethod() {
        return this.method_;
    }

    public String getPathInfo() {
        return this.pathInfo_;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo_ = pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated_;
    }

    public void setPathTranslated(String pathTranslated) {
        this.pathTranslated_ = pathTranslated;
    }

    public String getContextPath() {
        return this.servletContext_.getServletContextName();
    }

    public String getQueryString() {
        return this.queryString_;
    }

    public void setQueryString(String queryString) {
        this.queryString_ = queryString;
    }

    public String getRemoteUser() {
        return System.getProperty("user.name");
    }

    public boolean isUserInRole(String arg0) {
        throw new UnsupportedOperationException();
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException();
    }

    public String getRequestedSessionId() {
        if (this.session_ != null) {
            return this.session_.getId();
        }
        return null;
    }

    public String getRequestURI() {
        String contextPath = this.getContextPath();
        if (contextPath.equals("/")) {
            return this.servletPath_;
        }
        return String.valueOf(contextPath) + this.servletPath_;
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        url.append(this.scheme_);
        url.append("://");
        url.append(this.serverName_);
        if (this.scheme_.equals("http") && this.serverPort_ != 80 || this.scheme_.equals("https") && this.serverPort_ != 443) {
            url.append(':');
            url.append(this.serverPort_);
        }
        url.append(this.getRequestURI());
        return url;
    }

    public String getServletPath() {
        return this.servletPath_;
    }

    public HttpSession getSession(boolean create) {
        if (this.session_ != null) {
            return this.session_;
        }
        if (create) {
            this.session_ = new MockHttpSession(this.servletContext_);
        }
        if (this.session_ != null) {
            this.session_.access();
        }
        return this.session_;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public boolean isRequestedSessionIdValid() {
        if (this.session_ != null) {
            return this.session_.isValid();
        }
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.session_ != null;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public Object getAttribute(String name) {
        return this.attributes_.get(name);
    }

    public Enumeration getAttributeNames() {
        return new EnumerationAdapter(this.attributes_.keySet().iterator());
    }

    public void setAttribute(String name, Object value) {
        this.attributes_.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes_.remove(name);
    }

    public String getCharacterEncoding() {
        return this.characterEncoding_;
    }

    public void setCharacterEncoding(String characterEncoding) throws UnsupportedEncodingException {
        this.characterEncoding_ = characterEncoding;
    }

    public int getContentLength() {
        return this.contentLength_;
    }

    public void setContentLength(int contentLength) {
        this.contentLength_ = contentLength;
    }

    public String getContentType() {
        return this.contentType_;
    }

    public void setContentType(String contentType) {
        this.contentType_ = contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getParameter(String name) {
        String[] values = (String[])this.parameters_.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Enumeration getParameterNames() {
        return new EnumerationAdapter(this.parameters_.keySet().iterator());
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameters_.get(name);
    }

    public Map getParameterMap() {
        return this.parameters_;
    }

    public void addParameter(String name, String value) {
        String[] values = this.getParameterValues(name);
        if (values == null) {
            this.setParameter(name, value);
        } else {
            String[] newArray = new String[values.length + 1];
            System.arraycopy(values, 0, newArray, 0, values.length);
            newArray[newArray.length - 1] = value;
            this.parameters_.put(name, newArray);
        }
    }

    public void setParameter(String name, String value) {
        this.parameters_.put(name, new String[]{value});
    }

    public String getProtocol() {
        return this.protocol_;
    }

    public void setProtocol(String protocol) {
        this.protocol_ = protocol;
    }

    public String getScheme() {
        return this.scheme_;
    }

    public void setScheme(String scheme) {
        this.scheme_ = scheme;
    }

    public String getServerName() {
        return this.serverName_;
    }

    public void setServerName(String serverName) {
        this.serverName_ = serverName;
    }

    public int getServerPort() {
        return this.serverPort_;
    }

    public void setServerPort(int serverPort) {
        this.serverPort_ = serverPort;
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getRemoteAddr() {
        return this.remoteAddr_;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr_ = remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost_;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost_ = remoteHost;
    }

    public Locale getLocale() {
        return this.locale_;
    }

    public void setLocale(Locale locale) {
        this.locale_ = locale;
    }

    public Enumeration getLocales() {
        throw new UnsupportedOperationException();
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new MockRequestDispatcher();
    }

    public String getRealPath(String path) {
        return path;
    }
}

