/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.custom.tabbedpane;

import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import net.sourceforge.myfaces.custom.tabbedpane.TabChangeEvent;
import net.sourceforge.myfaces.custom.tabbedpane.TabChangeListener;

public class HtmlPanelTabbedPane
extends HtmlPanelGroup {
    private MethodBinding _tabChangeListener = null;
    public static final String COMPONENT_TYPE = "net.sourceforge.myfaces.HtmlPanelTabbedPane";
    public static final String COMPONENT_FAMILY = "javax.faces.Panel";
    private static final String DEFAULT_RENDERER_TYPE = "net.sourceforge.myfaces.TabbedPane";
    private static final int DEFAULT_SELECTEDINDEX = 0;
    private Integer _selectedIndex = null;
    private String _bgcolor = null;
    private String _activeTabStyleClass = null;
    private String _inactiveTabStyleClass = null;
    private String _activeSubStyleClass = null;
    private String _inactiveSubStyleClass = null;
    private String _tabContentStyleClass = null;

    public void addTabChangeListener(TabChangeListener listener) {
        this.addFacesListener(listener);
    }

    public void removeTabChangeListener(TabChangeListener listener) {
        this.removeFacesListener(listener);
    }

    public MethodBinding getTabChangeListener() {
        return this._tabChangeListener;
    }

    public void setTabChangeListener(MethodBinding tabChangeListener) {
        this._tabChangeListener = tabChangeListener;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        TabChangeEvent tabChangeEvent;
        if (event instanceof TabChangeEvent && (tabChangeEvent = (TabChangeEvent)event).getComponent() == this) {
            this.setSelectedIndex(tabChangeEvent.getNewTabIndex());
            this.getFacesContext().renderResponse();
        }
        super.broadcast(event);
        MethodBinding tabChangeListenerBinding = this.getTabChangeListener();
        if (tabChangeListenerBinding != null) {
            try {
                tabChangeListenerBinding.invoke(this.getFacesContext(), new Object[]{event});
            }
            catch (EvaluationException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof AbortProcessingException) {
                    throw (AbortProcessingException)cause;
                }
                throw e;
            }
        }
    }

    public HtmlPanelTabbedPane() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public void setSelectedIndex(int selectedIndex) {
        this._selectedIndex = new Integer(selectedIndex);
    }

    public int getSelectedIndex() {
        if (this._selectedIndex != null) {
            return this._selectedIndex;
        }
        ValueBinding vb = this.getValueBinding("selectedIndex");
        Integer v = vb != null ? (Integer)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : 0;
    }

    public void setBgcolor(String bgcolor) {
        this._bgcolor = bgcolor;
    }

    public String getBgcolor() {
        if (this._bgcolor != null) {
            return this._bgcolor;
        }
        ValueBinding vb = this.getValueBinding("bgcolor");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setActiveTabStyleClass(String activeTabStyleClass) {
        this._activeTabStyleClass = activeTabStyleClass;
    }

    public String getActiveTabStyleClass() {
        if (this._activeTabStyleClass != null) {
            return this._activeTabStyleClass;
        }
        ValueBinding vb = this.getValueBinding("activeTabStyleClass");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setInactiveTabStyleClass(String inactiveTabStyleClass) {
        this._inactiveTabStyleClass = inactiveTabStyleClass;
    }

    public String getInactiveTabStyleClass() {
        if (this._inactiveTabStyleClass != null) {
            return this._inactiveTabStyleClass;
        }
        ValueBinding vb = this.getValueBinding("inactiveTabStyleClass");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setActiveSubStyleClass(String activeSubStyleClass) {
        this._activeSubStyleClass = activeSubStyleClass;
    }

    public String getActiveSubStyleClass() {
        if (this._activeSubStyleClass != null) {
            return this._activeSubStyleClass;
        }
        ValueBinding vb = this.getValueBinding("activeSubStyleClass");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setInactiveSubStyleClass(String inactiveSubStyleClass) {
        this._inactiveSubStyleClass = inactiveSubStyleClass;
    }

    public String getInactiveSubStyleClass() {
        if (this._inactiveSubStyleClass != null) {
            return this._inactiveSubStyleClass;
        }
        ValueBinding vb = this.getValueBinding("inactiveSubStyleClass");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setTabContentStyleClass(String tabContentStyleClass) {
        this._tabContentStyleClass = tabContentStyleClass;
    }

    public String getTabContentStyleClass() {
        if (this._tabContentStyleClass != null) {
            return this._tabContentStyleClass;
        }
        ValueBinding vb = this.getValueBinding("tabContentStyleClass");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._selectedIndex, this._bgcolor, HtmlPanelTabbedPane.saveAttachedState((FacesContext)context, (Object)this._tabChangeListener), this._activeTabStyleClass, this._inactiveTabStyleClass, this._activeSubStyleClass, this._inactiveSubStyleClass, this._tabContentStyleClass};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._selectedIndex = (Integer)values[1];
        this._bgcolor = (String)values[2];
        this._tabChangeListener = (MethodBinding)HtmlPanelTabbedPane.restoreAttachedState((FacesContext)context, (Object)values[3]);
        this._activeTabStyleClass = (String)values[4];
        this._inactiveTabStyleClass = (String)values[5];
        this._activeSubStyleClass = (String)values[6];
        this._inactiveSubStyleClass = (String)values[7];
        this._tabContentStyleClass = (String)values[8];
    }
}

