/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.classgen.AsmClassGenerator2;
import org.codehaus.groovy.syntax.Token;

public class PrefixExpression
extends Expression {
    private Token operation;
    private Expression expression;

    public PrefixExpression(Token operation, Expression expression) {
        this.operation = operation;
        this.expression = expression;
    }

    public String toString() {
        return super.toString() + "[" + this.operation + this.expression + "]";
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitPrefixExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return new PrefixExpression(this.operation, transformer.transform(this.expression));
    }

    protected void resolveType(AsmClassGenerator2 resolver) {
        this.expression.resolve(resolver);
        this.setTypeClass(this.expression.getTypeClass());
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Token getOperation() {
        return this.operation;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getText() {
        return "(" + this.operation.getText() + this.expression.getText() + ")";
    }

    public Class getTypeClass() {
        return this.expression.getTypeClass();
    }

    public String getType() {
        return this.expression.getType();
    }
}

