/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.classgen.AsmClassGenerator2;

public class FieldExpression
extends Expression {
    private FieldNode field;

    public FieldExpression(FieldNode field) {
        this.field = field;
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitFieldExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return this;
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public String getTypeName() {
        return this.field.getType();
    }

    public FieldNode getField() {
        return this.field;
    }

    public String getText() {
        return "this." + this.field.getName();
    }

    public boolean isDynamic() {
        return this.field.isDynamicType();
    }

    public String getType() {
        return this.getTypeName();
    }

    public void setTypeClass(Class typeClass) {
        super.setTypeClass(typeClass);
        this.field.setType(typeClass.getName());
    }

    public void setType(String type) {
        super.setType(type);
        this.field.setType(type);
    }

    protected void resolveType(AsmClassGenerator2 resolver) {
        String fldType = this.field.getType();
        this.setType(fldType);
    }
}

