package org.seasar.jsf.template.impl.html;

import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlOutputLink;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.template.impl.AbstractUICommandFactory;
import org.w3c.dom.Node;

/**
 * @author higa
 *  
 */
public class HtmlOutputLinkFactory extends AbstractUICommandFactory {

	private static final String RENDERER_TYPE = "org.seasar.jsf.OutputLink";
	
	public HtmlOutputLinkFactory(Node node) {
		super(node);
		addCustomPropertyName(JsfConstants.ACTION_ATTR);
	}

	/**
	 * @see org.seasar.jsf.template.ComponentFactory#createComponent()
	 */
	public UIComponent createComponent() {
		HtmlOutputLink component = new HtmlOutputLink();
		component.setRendererType(RENDERER_TYPE);
		setProperties(component);
		return component;
	}
	
	/**
	 * @see org.seasar.jsf.template.impl.AbstractComponentFactory#renameProperties()
	 */
	protected void renameProperties() {
		super.renameProperties();
		renameProperty(JsfConstants.HREF_ATTR, JsfConstants.VALUE_ATTR);
	}
}