package org.seasar.jsf.template.impl;

import org.seasar.jsf.template.ComponentFactory;
import org.seasar.jsf.template.NodeHandler;
import org.w3c.dom.Node;

/**
 * @author higa
 *
 */
public class UIElementNodeHandler implements NodeHandler {

	public UIElementNodeHandler() {
	}

	/**
	 * @see org.seasar.jsf.template.NodeHandler#isHandleable(org.w3c.dom.Node)
	 */
	public boolean isHandleable(Node node) {
		return node.getNodeType() == Node.ELEMENT_NODE;
	}

	/**
	 * @see org.seasar.jsf.template.NodeHandler#createComponentFactory(org.w3c.dom.Node)
	 */
	public ComponentFactory createComponentFactory(Node node) {
		return new UIElementNodeFactory(node);
	}

}
