package org.seasar.jsf.template.impl;

import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.el.MethodBinding;

import org.seasar.framework.util.StringUtil;
import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.el.MethodBindingImpl;
import org.seasar.jsf.el.SimpleMethodBinding;
import org.seasar.jsf.util.BindingUtil;
import org.w3c.dom.Node;

/**
 * @author higa
 *
 */
public abstract class AbstractUICommandFactory extends AbstractComponentFactory {

	public AbstractUICommandFactory(Node node) {
		super(node);
		addCustomPropertyName(JsfConstants.ACTION_ATTR);
	}
	
	
	/**
	 * @see org.seasar.jsf.template.impl.AbstractComponentFactory#setProperties(javax.faces.component.UIComponent)
	 */
	protected void setProperties(UIComponent component) {
		super.setProperties(component);
		String action = (String) getProperty(JsfConstants.ACTION_ATTR);
		if (!StringUtil.isEmpty(action)) {
			MethodBinding binding = null;
			if (BindingUtil.isValueReference(action)) {
				binding = new MethodBindingImpl(action);
			} else {
				binding = new SimpleMethodBinding(action);
			}
			((UICommand) component).setAction(binding);
		}
	}
}
