/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.proxy;

import net.sf.cglib.core.AbstractClassGenerator;
import net.sf.cglib.core.KeyFactory;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.CallbackUtils;
import net.sf.cglib.proxy.EnhancerEmitter;
import net.sf.cglib.proxy.Factory;
import org.objectweb.asm.ClassVisitor;

public class Enhancer
extends AbstractClassGenerator {
    private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source((class$net$sf$cglib$proxy$Enhancer == null ? (class$net$sf$cglib$proxy$Enhancer = Enhancer.class$("net.sf.cglib.proxy.Enhancer")) : class$net$sf$cglib$proxy$Enhancer).getName());
    private static final EnhancerKey KEY_FACTORY = (EnhancerKey)((Object)KeyFactory.create(class$net$sf$cglib$proxy$Enhancer$EnhancerKey == null ? (class$net$sf$cglib$proxy$Enhancer$EnhancerKey = Enhancer.class$("net.sf.cglib.proxy.Enhancer$EnhancerKey")) : class$net$sf$cglib$proxy$Enhancer$EnhancerKey, KeyFactory.CLASS_BY_NAME));
    private Class[] interfaces;
    private CallbackFilter filter;
    private Callback[] callbacks;
    private Class[] callbackTypes;
    private boolean classOnly;
    private Class superclass;
    private Class[] argumentTypes;
    private Object[] arguments;
    private boolean useFactory = true;
    static /* synthetic */ Class class$net$sf$cglib$proxy$Enhancer;
    static /* synthetic */ Class class$net$sf$cglib$proxy$Enhancer$EnhancerKey;
    static /* synthetic */ Class class$java$lang$Object;

    public Enhancer() {
        super(SOURCE);
    }

    public void setSuperclass(Class superclass) {
        if (superclass != null && superclass.isInterface()) {
            this.setInterfaces(new Class[]{superclass});
        } else {
            this.superclass = superclass != null && superclass.equals(class$java$lang$Object == null ? (class$java$lang$Object = Enhancer.class$("java.lang.Object")) : class$java$lang$Object) ? null : superclass;
        }
    }

    public void setInterfaces(Class[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setCallbackFilter(CallbackFilter filter) {
        this.filter = filter;
    }

    public void setCallback(Callback callback) {
        this.setCallbacks(new Callback[]{callback});
    }

    public void setCallbacks(Callback[] callbacks) {
        if (callbacks != null && callbacks.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty");
        }
        this.callbacks = callbacks;
    }

    public void setUseFactory(boolean useFactory) {
        this.useFactory = useFactory;
    }

    public void setCallbackType(Class callbackType) {
        this.setCallbackTypes(new Class[]{callbackType});
    }

    public void setCallbackTypes(Class[] callbackTypes) {
        if (callbackTypes != null && callbackTypes.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty");
        }
        this.callbackTypes = callbackTypes;
    }

    public Object create() {
        this.classOnly = false;
        this.argumentTypes = null;
        return this.createHelper();
    }

    public Object create(Class[] argumentTypes, Object[] arguments) {
        this.classOnly = false;
        if (argumentTypes == null || arguments == null || argumentTypes.length != arguments.length) {
            throw new IllegalArgumentException("Arguments must be non-null and of equal length");
        }
        this.argumentTypes = argumentTypes;
        this.arguments = arguments;
        return this.createHelper();
    }

    public Class createClass() {
        this.classOnly = true;
        return (Class)this.createHelper();
    }

    private Object createHelper() {
        int i;
        if (this.classOnly ^ this.callbacks == null) {
            if (this.classOnly) {
                throw new IllegalStateException("createClass does not accept callbacks");
            }
            throw new IllegalStateException("callbacks are required unless using createClass");
        }
        if (this.callbacks == null && this.callbackTypes == null) {
            throw new IllegalStateException("Either callbacks or callback types are always required");
        }
        if (this.callbacks != null && this.callbackTypes != null) {
            if (this.callbacks.length != this.callbackTypes.length) {
                throw new IllegalStateException("Lengths of callback and callback types array must be the same");
            }
            i = 0;
            while (i < this.callbacks.length) {
                CallbackUtils.getGenerator(this.callbackTypes[i]);
                if (this.callbacks[i] == null) {
                    throw new IllegalStateException("Callback cannot be null");
                }
                if (!this.callbackTypes[i].isAssignableFrom(this.callbacks[i].getClass())) {
                    throw new IllegalStateException("Callback " + this.callbacks[i] + " is not assignable to " + this.callbackTypes[i]);
                }
                ++i;
            }
        } else if (this.callbacks != null) {
            this.callbackTypes = new Class[this.callbacks.length];
            i = 0;
            while (i < this.callbacks.length) {
                this.callbackTypes[i] = CallbackUtils.determineType(this.callbacks[i]);
                ++i;
            }
        } else {
            i = 0;
            while (i < this.callbackTypes.length) {
                CallbackUtils.getGenerator(this.callbackTypes[i]);
                ++i;
            }
        }
        if (this.filter == null) {
            if (this.callbackTypes.length > 1) {
                throw new IllegalStateException("Multiple callback types possible but no filter specified");
            }
            this.filter = CallbackFilter.ALL_ZERO;
        }
        if (this.superclass != null) {
            this.setNamePrefix(this.superclass.getName());
        } else if (this.interfaces != null) {
            this.setNamePrefix(this.interfaces[ReflectUtils.findPackageProtected(this.interfaces)].getName());
        }
        Object key = KEY_FACTORY.newInstance(this.superclass, this.interfaces, this.filter, this.callbackTypes, this.useFactory);
        return super.create(key);
    }

    protected ClassLoader getDefaultClassLoader() {
        if (this.superclass != null) {
            return this.superclass.getClassLoader();
        }
        if (this.interfaces != null) {
            return this.interfaces[0].getClassLoader();
        }
        return null;
    }

    public void generateClass(ClassVisitor v) throws Exception {
        new EnhancerEmitter(v, this.getClassName(), this.superclass, this.interfaces, this.filter, this.callbackTypes, this.useFactory);
    }

    protected Object firstInstance(Class type) throws Exception {
        if (this.classOnly) {
            return type;
        }
        return this.createUsingReflection(type);
    }

    protected Object nextInstance(Object instance) {
        Class<?> protoclass;
        Class<?> clazz = protoclass = instance instanceof Class ? (Class<?>)instance : instance.getClass();
        if (this.classOnly) {
            return protoclass;
        }
        if (instance instanceof Factory) {
            if (this.argumentTypes != null) {
                return ((Factory)instance).newInstance(this.argumentTypes, this.arguments, this.callbacks);
            }
            return ((Factory)instance).newInstance(this.callbacks);
        }
        return this.createUsingReflection(protoclass);
    }

    public static void registerCallbacks(Class generatedClass, Callback[] callbacks) {
        EnhancerEmitter.setThreadCallbacks(generatedClass, callbacks);
    }

    private Object createUsingReflection(Class type) {
        EnhancerEmitter.setThreadCallbacks(type, this.callbacks);
        if (this.argumentTypes != null) {
            return ReflectUtils.newInstance(type, this.argumentTypes, this.arguments);
        }
        return ReflectUtils.newInstance(type);
    }

    public static Object create(Class type, Callback callback) {
        Enhancer e = new Enhancer();
        e.setSuperclass(type);
        e.setCallback(callback);
        return e.create();
    }

    public static Object create(Class superclass, Class[] interfaces, Callback callback) {
        Enhancer e = new Enhancer();
        e.setSuperclass(superclass);
        e.setInterfaces(interfaces);
        e.setCallback(callback);
        return e.create();
    }

    public static Object create(Class superclass, Class[] interfaces, CallbackFilter filter, Callback[] callbacks) {
        Enhancer e = new Enhancer();
        e.setSuperclass(superclass);
        e.setInterfaces(interfaces);
        e.setCallbackFilter(filter);
        e.setCallbacks(callbacks);
        return e.create();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static interface EnhancerKey {
        public Object newInstance(Class var1, Class[] var2, CallbackFilter var3, Class[] var4, boolean var5);
    }
}

