/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.flash;

import com.carbonfive.flash.ASTranslationException;
import com.carbonfive.flash.ASTranslator;
import com.carbonfive.flash.test.TestBean;
import flashgateway.io.ASObject;
import java.beans.Beans;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ASTranslatorTest
extends TestCase {
    private static final Log log = LogFactory.getLog((Class)(class$com$carbonfive$flash$ASTranslatorTest == null ? (class$com$carbonfive$flash$ASTranslatorTest = ASTranslatorTest.class$("com.carbonfive.flash.ASTranslatorTest")) : class$com$carbonfive$flash$ASTranslatorTest));
    static /* synthetic */ Class class$com$carbonfive$flash$ASTranslatorTest;
    static /* synthetic */ Class class$com$carbonfive$flash$test$TestBean;
    static /* synthetic */ Class class$com$carbonfive$flash$ASTranslatorTest$DeepTestBean;
    static /* synthetic */ Class class$com$carbonfive$flash$ASTranslatorTest$ComplexSpecificTestBean;
    static /* synthetic */ Class class$com$carbonfive$flash$ASTranslatorTest$ComplexGenericTestBean;
    static /* synthetic */ Class class$com$carbonfive$flash$ASTranslatorTest$CircularTestBean;

    public ASTranslatorTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(class$com$carbonfive$flash$ASTranslatorTest == null ? (class$com$carbonfive$flash$ASTranslatorTest = ASTranslatorTest.class$("com.carbonfive.flash.ASTranslatorTest")) : class$com$carbonfive$flash$ASTranslatorTest);
        return suite;
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testTestObjects() throws Exception {
        Beans.instantiate(((Object)((Object)this)).getClass().getClassLoader(), (class$com$carbonfive$flash$test$TestBean == null ? (class$com$carbonfive$flash$test$TestBean = ASTranslatorTest.class$("com.carbonfive.flash.test.TestBean")) : class$com$carbonfive$flash$test$TestBean).getName());
        Beans.instantiate(((Object)((Object)this)).getClass().getClassLoader(), (class$com$carbonfive$flash$ASTranslatorTest$DeepTestBean == null ? (class$com$carbonfive$flash$ASTranslatorTest$DeepTestBean = ASTranslatorTest.class$("com.carbonfive.flash.ASTranslatorTest$DeepTestBean")) : class$com$carbonfive$flash$ASTranslatorTest$DeepTestBean).getName());
    }

    public void testTranslateToASObject() throws Exception {
        TestBean bean = TestBean.getTestBean();
        ASObject as = (ASObject)new ASTranslator().toActionScript(bean);
        this.validateTestBean(bean, as);
    }

    public void testDeepTranslateToASObject() throws Exception {
        TestBean bean = TestBean.getTestBean();
        DeepTestBean deepbean = new DeepTestBean();
        deepbean.setBeanField(bean);
        ASObject as = (ASObject)new ASTranslator().toActionScript(deepbean);
        ASTranslatorTest.assertNotNull((Object)as);
        ASTranslatorTest.assertEquals((String)(class$com$carbonfive$flash$ASTranslatorTest$DeepTestBean == null ? (class$com$carbonfive$flash$ASTranslatorTest$DeepTestBean = ASTranslatorTest.class$("com.carbonfive.flash.ASTranslatorTest$DeepTestBean")) : class$com$carbonfive$flash$ASTranslatorTest$DeepTestBean).getName(), (String)as.getType());
        ASTranslatorTest.assertTrue((boolean)as.containsKey((Object)"beanField"));
        ASObject as2 = (ASObject)as.get((Object)"beanField");
        this.validateTestBean(bean, as2);
    }

    public void testComplexSpecificTranslateToASObject() throws Exception {
        ComplexSpecificTestBean a = new ComplexSpecificTestBean();
        a.setListField(new ArrayList());
        a.getListField().add("one");
        TestBean bean = TestBean.getTestBean();
        a.getListField().add(bean);
        a.getListField().add(bean);
        a.setMapField(new HashMap());
        a.getMapField().put("this", "that");
        a.getMapField().put("bean", bean);
        ASObject as = (ASObject)new ASTranslator().toActionScript(a);
        ASTranslatorTest.assertNotNull((Object)as);
        ASTranslatorTest.assertEquals((String)(class$com$carbonfive$flash$ASTranslatorTest$ComplexSpecificTestBean == null ? (class$com$carbonfive$flash$ASTranslatorTest$ComplexSpecificTestBean = ASTranslatorTest.class$("com.carbonfive.flash.ASTranslatorTest$ComplexSpecificTestBean")) : class$com$carbonfive$flash$ASTranslatorTest$ComplexSpecificTestBean).getName(), (String)as.getType());
        ASTranslatorTest.assertTrue((boolean)as.containsKey((Object)"listField"));
        ArrayList list = (ArrayList)as.get((Object)"listField");
        ASTranslatorTest.assertNotNull((Object)list);
        ASTranslatorTest.assertEquals((int)3, (int)list.size());
        ASTranslatorTest.assertEquals((Object)"one", list.get(0));
        ASObject as1 = (ASObject)list.get(1);
        this.validateTestBean(bean, as1);
        ASObject as2 = (ASObject)list.get(2);
        this.validateTestBean(bean, as2);
        ASTranslatorTest.assertTrue((boolean)as.containsKey((Object)"mapField"));
        HashMap map = (HashMap)as.get((Object)"mapField");
        ASTranslatorTest.assertNotNull((Object)map);
        ASTranslatorTest.assertTrue((boolean)map.containsKey("this"));
        ASTranslatorTest.assertEquals((Object)"that", map.get("this"));
        ASObject as3 = (ASObject)map.get("bean");
        this.validateTestBean(bean, as2);
        ASTranslatorTest.assertTrue((as2 == as3 ? 1 : 0) != 0);
    }

    public void testTranslateToBean() throws Exception {
        ASObject as = new ASObject();
        as.setType((class$com$carbonfive$flash$test$TestBean == null ? (class$com$carbonfive$flash$test$TestBean = ASTranslatorTest.class$("com.carbonfive.flash.test.TestBean")) : class$com$carbonfive$flash$test$TestBean).getName());
        as.put((Object)"strField", (Object)"A string");
        as.put((Object)"intField", (Object)new Double(3.0));
        TestBean bean = (TestBean)new ASTranslator().fromActionScript(as);
        ASTranslatorTest.assertNotNull((Object)bean);
        ASTranslatorTest.assertEquals((Object)as.get((Object)"intField"), (Object)new Double(bean.getIntField()));
        ASTranslatorTest.assertEquals((Object)as.get((Object)"strField"), (Object)bean.getStrField());
    }

    public void testDeepTranslateToBean() throws Exception {
        ASObject as = new ASObject();
        as.setType((class$com$carbonfive$flash$ASTranslatorTest$DeepTestBean == null ? (class$com$carbonfive$flash$ASTranslatorTest$DeepTestBean = ASTranslatorTest.class$("com.carbonfive.flash.ASTranslatorTest$DeepTestBean")) : class$com$carbonfive$flash$ASTranslatorTest$DeepTestBean).getName());
        ASObject as2 = new ASObject();
        as2.setType((class$com$carbonfive$flash$test$TestBean == null ? (class$com$carbonfive$flash$test$TestBean = ASTranslatorTest.class$("com.carbonfive.flash.test.TestBean")) : class$com$carbonfive$flash$test$TestBean).getName());
        as2.put((Object)"strField", (Object)"A string");
        as2.put((Object)"intField", (Object)new Double(3.0));
        as.put((Object)"beanField", (Object)as2);
        DeepTestBean deepBean = (DeepTestBean)new ASTranslator().fromActionScript(as);
        ASTranslatorTest.assertNotNull((Object)deepBean);
        TestBean bean = deepBean.getBeanField();
        ASTranslatorTest.assertNotNull((Object)bean);
        ASTranslatorTest.assertEquals((Object)as2.get((Object)"intField"), (Object)new Double(bean.getIntField()));
        ASTranslatorTest.assertEquals((Object)as2.get((Object)"strField"), (Object)bean.getStrField());
    }

    public void testBeanCollection() throws Exception {
        TestBean bean = new TestBean();
        bean.setStrField("testtesttest");
        ArrayList<TestBean> listOfBeans = new ArrayList<TestBean>();
        for (int element = 0; element < 10; ++element) {
            listOfBeans.add(bean);
        }
        ASTranslatorTest.assertEquals((int)10, (int)listOfBeans.size());
        ArrayList listOfBeansTranslatedToASObjects = (ArrayList)new ASTranslator().toActionScript(listOfBeans);
        ASTranslatorTest.assertEquals((int)10, (int)listOfBeansTranslatedToASObjects.size());
        Object uncastElementFromList = listOfBeansTranslatedToASObjects.get(0);
        ASObject aso = (ASObject)uncastElementFromList;
        ASTranslatorTest.assertEquals((Object)"testtesttest", (Object)aso.get((Object)"strField"));
    }

    public void testComplexSpecificTranslateToBean() throws Exception {
        ASObject as = new ASObject();
        as.setType((class$com$carbonfive$flash$ASTranslatorTest$ComplexSpecificTestBean == null ? (class$com$carbonfive$flash$ASTranslatorTest$ComplexSpecificTestBean = ASTranslatorTest.class$("com.carbonfive.flash.ASTranslatorTest$ComplexSpecificTestBean")) : class$com$carbonfive$flash$ASTranslatorTest$ComplexSpecificTestBean).getName());
        ArrayList<String> asList = new ArrayList<String>();
        asList.add("one");
        asList.add("two");
        ASObject as2 = new ASObject();
        as2.setType((class$com$carbonfive$flash$test$TestBean == null ? (class$com$carbonfive$flash$test$TestBean = ASTranslatorTest.class$("com.carbonfive.flash.test.TestBean")) : class$com$carbonfive$flash$test$TestBean).getName());
        as2.put((Object)"strField", (Object)"hello");
        as2.put((Object)"intField", (Object)new Double(10.0));
        asList.add((String)as2);
        ASObject asMap = new ASObject();
        asMap.put((Object)"hi", (Object)"there");
        asMap.put((Object)"bean", (Object)as2);
        as.put((Object)"listField", asList);
        as.put((Object)"mapField", (Object)asMap);
        ComplexSpecificTestBean cbean = (ComplexSpecificTestBean)new ASTranslator().fromActionScript(as);
        ASTranslatorTest.assertNotNull((Object)cbean);
        ASTranslatorTest.assertNotNull((Object)cbean.getListField());
        ASTranslatorTest.assertEquals((int)3, (int)cbean.getListField().size());
        ASTranslatorTest.assertEquals((Object)"one", cbean.getListField().get(0));
        ASTranslatorTest.assertEquals((Object)"two", cbean.getListField().get(1));
        ASTranslatorTest.assertTrue((String)("Should be TestBean: " + cbean.getListField().get(2).getClass().getName()), (boolean)(cbean.getListField().get(2) instanceof TestBean));
        TestBean tbean = (TestBean)cbean.getListField().get(2);
        ASTranslatorTest.assertEquals((String)"hello", (String)tbean.getStrField());
        ASTranslatorTest.assertEquals((int)10, (int)tbean.getIntField());
        ASTranslatorTest.assertNotNull((Object)cbean.getMapField());
        ASTranslatorTest.assertEquals((Object)"there", cbean.getMapField().get("hi"));
        ASTranslatorTest.assertTrue((String)("Should be TestBean: " + cbean.getMapField().get("bean").getClass().getName()), (boolean)(cbean.getMapField().get("bean") instanceof TestBean));
        tbean = (TestBean)cbean.getMapField().get("bean");
        ASTranslatorTest.assertEquals((String)"hello", (String)tbean.getStrField());
        ASTranslatorTest.assertEquals((int)10, (int)tbean.getIntField());
    }

    public void testComplexGenericTranslateToASObject() throws Exception {
        ASObject as = new ASObject();
        as.setType((class$com$carbonfive$flash$ASTranslatorTest$ComplexGenericTestBean == null ? (class$com$carbonfive$flash$ASTranslatorTest$ComplexGenericTestBean = ASTranslatorTest.class$("com.carbonfive.flash.ASTranslatorTest$ComplexGenericTestBean")) : class$com$carbonfive$flash$ASTranslatorTest$ComplexGenericTestBean).getName());
        ArrayList<String> asList = new ArrayList<String>();
        asList.add("one");
        asList.add("two");
        ASObject as2 = new ASObject();
        as2.setType((class$com$carbonfive$flash$test$TestBean == null ? (class$com$carbonfive$flash$test$TestBean = ASTranslatorTest.class$("com.carbonfive.flash.test.TestBean")) : class$com$carbonfive$flash$test$TestBean).getName());
        as2.put((Object)"strField", (Object)"hello");
        as2.put((Object)"intField", (Object)new Double(10.0));
        asList.add((String)as2);
        ASObject asMap = new ASObject();
        asMap.put((Object)"hi", (Object)"there");
        asMap.put((Object)"bean", (Object)as2);
        as.put((Object)"listField", asList);
        as.put((Object)"mapField", (Object)asMap);
        Object decoded = new ASTranslator().fromActionScript(as);
        ASTranslatorTest.assertNotNull((Object)decoded);
        log.info((Object)("ASObject type: " + as.getType()));
        ASTranslatorTest.assertTrue((String)("Should be ComplexGenericTestBean, but is: " + decoded.getClass().getName()), (boolean)(decoded instanceof ComplexGenericTestBean));
        ComplexGenericTestBean cbean = (ComplexGenericTestBean)decoded;
        ASTranslatorTest.assertNotNull((Object)cbean.getListField());
        ASTranslatorTest.assertEquals((int)3, (int)cbean.getListField().size());
        ASTranslatorTest.assertEquals((Object)"one", cbean.getListField().get(0));
        ASTranslatorTest.assertEquals((Object)"two", cbean.getListField().get(1));
        ASTranslatorTest.assertTrue((boolean)(cbean.getListField().get(2) instanceof TestBean));
        TestBean tbean = (TestBean)cbean.getListField().get(2);
        ASTranslatorTest.assertEquals((String)"hello", (String)tbean.getStrField());
        ASTranslatorTest.assertEquals((int)10, (int)tbean.getIntField());
        ASTranslatorTest.assertNotNull((Object)cbean.getMapField());
        ASTranslatorTest.assertEquals((Object)"there", cbean.getMapField().get("hi"));
        ASTranslatorTest.assertTrue((boolean)(cbean.getMapField().get("bean") instanceof TestBean));
        tbean = (TestBean)cbean.getMapField().get("bean");
        ASTranslatorTest.assertEquals((String)"hello", (String)tbean.getStrField());
        ASTranslatorTest.assertEquals((int)10, (int)tbean.getIntField());
    }

    public void testComplexGenericTranslateToBean() throws Exception {
    }

    public void testReferencesTranslateToASObject() throws Exception {
        HashMap<String, TestBean> map = new HashMap<String, TestBean>();
        TestBean bean = TestBean.getTestBean();
        map.put("one", bean);
        map.put("two", bean);
        ASObject as = (ASObject)new ASTranslator().toActionScript(map);
        ASTranslatorTest.assertNotNull((Object)as);
        ASTranslatorTest.assertNotNull((Object)as.get((Object)"one"));
        ASTranslatorTest.assertNotNull((Object)as.get((Object)"two"));
        ASTranslatorTest.assertTrue((String)("should be the same object reference:\n" + as.get((Object)"one") + "\n" + as.get((Object)"two")), (as.get((Object)"one") == as.get((Object)"two") ? 1 : 0) != 0);
    }

    public void testNoReferencesTranslateToASObject() throws Exception {
        ComplexSpecificTestBean bean = new ComplexSpecificTestBean();
        ArrayList<TestBean> list = new ArrayList<TestBean>();
        list.add(TestBean.getTestBean());
        list.add(TestBean.getTestBean());
        bean.setListField(list);
        ASObject as = (ASObject)new ASTranslator().toActionScript(bean);
        ArrayList asList = (ArrayList)as.get((Object)"listField");
        ASTranslatorTest.assertNotNull(asList.get(0));
        ASTranslatorTest.assertNotNull(asList.get(1));
        ASTranslatorTest.assertTrue((String)"should not be the same object reference", (asList.get(0) != asList.get(1) ? 1 : 0) != 0);
    }

    public void testReferencesTranslateToBean() throws Exception {
        ASObject as = new ASObject();
        as.setType((class$com$carbonfive$flash$ASTranslatorTest$ComplexSpecificTestBean == null ? (class$com$carbonfive$flash$ASTranslatorTest$ComplexSpecificTestBean = ASTranslatorTest.class$("com.carbonfive.flash.ASTranslatorTest$ComplexSpecificTestBean")) : class$com$carbonfive$flash$ASTranslatorTest$ComplexSpecificTestBean).getName());
        ASObject asBean1 = new ASObject();
        asBean1.setType((class$com$carbonfive$flash$test$TestBean == null ? (class$com$carbonfive$flash$test$TestBean = ASTranslatorTest.class$("com.carbonfive.flash.test.TestBean")) : class$com$carbonfive$flash$test$TestBean).getName());
        asBean1.put((Object)"strField", (Object)"hello");
        asBean1.put((Object)"intField", (Object)new Double(10.0));
        ASObject asBean2 = new ASObject();
        asBean2.setType((class$com$carbonfive$flash$test$TestBean == null ? (class$com$carbonfive$flash$test$TestBean = ASTranslatorTest.class$("com.carbonfive.flash.test.TestBean")) : class$com$carbonfive$flash$test$TestBean).getName());
        asBean2.put((Object)"strField", (Object)"hello");
        asBean2.put((Object)"intField", (Object)new Double(10.0));
        ASObject asMap = new ASObject();
        asMap.put((Object)"one", (Object)asBean1);
        asMap.put((Object)"two", (Object)asBean2);
        asMap.put((Object)"three", (Object)asBean1);
        as.put((Object)"mapField", (Object)asMap);
        ComplexSpecificTestBean cbean = (ComplexSpecificTestBean)new ASTranslator().fromActionScript(as);
        ASTranslatorTest.assertNotNull((Object)cbean);
        ASTranslatorTest.assertNotNull((Object)cbean.getMapField());
        ASTranslatorTest.assertTrue((String)"one and two should not be ==", (cbean.getMapField().get("one") != cbean.getMapField().get("two") ? 1 : 0) != 0);
        ASTranslatorTest.assertTrue((String)"two and three should not be ==", (cbean.getMapField().get("two") != cbean.getMapField().get("three") ? 1 : 0) != 0);
        ASTranslatorTest.assertTrue((String)"one and three should be ==", (cbean.getMapField().get("one") == cbean.getMapField().get("three") ? 1 : 0) != 0);
    }

    public void testNoReferencesTranslateToBean() throws Exception {
        ASObject as = new ASObject();
        as.setType((class$com$carbonfive$flash$ASTranslatorTest$ComplexSpecificTestBean == null ? (class$com$carbonfive$flash$ASTranslatorTest$ComplexSpecificTestBean = ASTranslatorTest.class$("com.carbonfive.flash.ASTranslatorTest$ComplexSpecificTestBean")) : class$com$carbonfive$flash$ASTranslatorTest$ComplexSpecificTestBean).getName());
        ASObject asBean1 = new ASObject();
        asBean1.setType((class$com$carbonfive$flash$test$TestBean == null ? (class$com$carbonfive$flash$test$TestBean = ASTranslatorTest.class$("com.carbonfive.flash.test.TestBean")) : class$com$carbonfive$flash$test$TestBean).getName());
        asBean1.put((Object)"strField", (Object)"hello");
        asBean1.put((Object)"intField", (Object)new Double(10.0));
        ASObject asBean2 = new ASObject();
        asBean2.setType((class$com$carbonfive$flash$test$TestBean == null ? (class$com$carbonfive$flash$test$TestBean = ASTranslatorTest.class$("com.carbonfive.flash.test.TestBean")) : class$com$carbonfive$flash$test$TestBean).getName());
        asBean2.put((Object)"strField", (Object)"hello");
        asBean2.put((Object)"intField", (Object)new Double(10.0));
        ArrayList<ASObject> asList = new ArrayList<ASObject>();
        asList.add(asBean1);
        asList.add(asBean2);
        as.put((Object)"listField", asList);
        ComplexSpecificTestBean bean = (ComplexSpecificTestBean)new ASTranslator().fromActionScript(as);
        ArrayList list = bean.getListField();
        ASTranslatorTest.assertNotNull(list.get(0));
        ASTranslatorTest.assertNotNull(list.get(1));
        ASTranslatorTest.assertTrue((String)"should not be the same object reference", (list.get(0) != list.get(1) ? 1 : 0) != 0);
    }

    public void testTranslateEmptySet() throws Exception {
        Object encodedSet = new ASTranslator().toActionScript(new HashSet());
        ASTranslatorTest.assertNotNull((Object)encodedSet);
        ArrayList list = new ArrayList();
        ASTranslatorTest.assertEquals(list, (Object)encodedSet);
    }

    public void testCircularTranslateToASObject() throws Exception {
        CircularTestBean ctb = new CircularTestBean();
        ctb.setMe(ctb);
        Object encoded = new ASTranslator().toActionScript(ctb);
        ASTranslatorTest.assertNotNull((Object)encoded);
        ASTranslatorTest.assertTrue((boolean)(encoded instanceof ASObject));
        ASObject as = (ASObject)encoded;
        ASTranslatorTest.assertTrue((as.get((Object)"me") == as ? 1 : 0) != 0);
    }

    public void testCircularTranslateFromASObject() throws Exception {
        ASObject as = new ASObject();
        as.setType((class$com$carbonfive$flash$ASTranslatorTest$CircularTestBean == null ? (class$com$carbonfive$flash$ASTranslatorTest$CircularTestBean = ASTranslatorTest.class$("com.carbonfive.flash.ASTranslatorTest$CircularTestBean")) : class$com$carbonfive$flash$ASTranslatorTest$CircularTestBean).getName());
        as.put((Object)"me", (Object)as);
        Object obj = new ASTranslator().fromActionScript(as);
        ASTranslatorTest.assertNotNull((Object)obj);
        ASTranslatorTest.assertTrue((boolean)(obj instanceof CircularTestBean));
        CircularTestBean ctb = (CircularTestBean)obj;
        ASTranslatorTest.assertTrue((ctb == ctb.getMe() ? 1 : 0) != 0);
    }

    public void testCircularEquivalence() throws Exception {
        CircularTestBean ctb1 = new CircularTestBean();
        CircularTestBean ctb2 = new CircularTestBean();
        ctb1.setMe(ctb2);
        ASTranslatorTest.assertEquals((Object)ctb1, (Object)ctb2);
        ASTranslatorTest.assertTrue((ctb1 != ctb2 ? 1 : 0) != 0);
        ASTranslator trans = new ASTranslator();
        Object encoded = trans.toActionScript(ctb1);
        ASTranslatorTest.assertNotNull((Object)encoded);
        ASTranslatorTest.assertTrue((boolean)(encoded instanceof ASObject));
        ASObject as = (ASObject)encoded;
        ASTranslatorTest.assertTrue((as.get((Object)"me") != as ? 1 : 0) != 0);
        trans.setUseEquivalence(true);
        encoded = trans.toActionScript(ctb1);
        ASTranslatorTest.assertNotNull((Object)encoded);
        ASTranslatorTest.assertTrue((boolean)(encoded instanceof ASObject));
        as = (ASObject)encoded;
        ASTranslatorTest.assertTrue((String)("as = " + as + "\n as.get(me) = " + as.get((Object)"me")), (as.get((Object)"me") == as ? 1 : 0) != 0);
    }

    public void testIgnoreClass() throws Exception {
        ASTranslator trans = new ASTranslator();
        trans.ignoreClass(class$com$carbonfive$flash$test$TestBean == null ? (class$com$carbonfive$flash$test$TestBean = ASTranslatorTest.class$("com.carbonfive.flash.test.TestBean")) : class$com$carbonfive$flash$test$TestBean);
        TestBean bean = new TestBean();
        ASObject aso = (ASObject)trans.toActionScript(bean);
        ASTranslatorTest.assertNull((Object)aso);
    }

    public void testIgnoreSuperclass() throws Exception {
        ASTranslator trans = new ASTranslator();
        trans.ignoreClass(class$com$carbonfive$flash$test$TestBean == null ? (class$com$carbonfive$flash$test$TestBean = ASTranslatorTest.class$("com.carbonfive.flash.test.TestBean")) : class$com$carbonfive$flash$test$TestBean);
        TestSuperBean bean = new TestSuperBean();
        ASObject aso = (ASObject)trans.toActionScript(bean);
        ASTranslatorTest.assertNull((Object)aso);
    }

    public void testIgnoreSuperclass2() throws Exception {
        ASTranslator trans = new ASTranslator();
        trans.ignoreClass(class$com$carbonfive$flash$test$TestBean == null ? (class$com$carbonfive$flash$test$TestBean = ASTranslatorTest.class$("com.carbonfive.flash.test.TestBean")) : class$com$carbonfive$flash$test$TestBean);
        TestSuperBean2 bean = new TestSuperBean2();
        ASObject aso = (ASObject)trans.toActionScript(bean);
        ASTranslatorTest.assertNotNull((Object)aso);
        ASTranslatorTest.assertNull((Object)aso.get((Object)"bean"));
    }

    public void testIgnoreProperty() throws Exception {
        ASTranslator trans = new ASTranslator();
        trans.ignoreProperty(class$com$carbonfive$flash$test$TestBean == null ? (class$com$carbonfive$flash$test$TestBean = ASTranslatorTest.class$("com.carbonfive.flash.test.TestBean")) : class$com$carbonfive$flash$test$TestBean, "intField");
        TestBean bean = TestBean.getTestBean();
        ASObject aso = (ASObject)trans.toActionScript(bean);
        ASTranslatorTest.assertNotNull((Object)aso);
        ASTranslatorTest.assertNull((Object)aso.get((Object)"intField"));
    }

    public void testInfiniteLoop() throws Exception {
        try {
            new ASTranslator().toActionScript(new InfiniteLoopBean());
            ASTranslatorTest.fail((String)"Should have caught infinite loop");
        }
        catch (ASTranslationException ase) {
            log.info((Object)("GOOD: " + ase.getMessage()));
        }
    }

    public void testDecodeASObjectWithDeepNullValue() throws Exception {
        ASObject a = new ASObject();
        ASObject b = new ASObject();
        a.put((Object)"a-foo", (Object)"a-bar");
        b.put((Object)"b-foo", (Object)"b-bar");
        b.put((Object)"b-null", null);
        a.put((Object)"a-b", (Object)b);
        Object decoded = new ASTranslator().fromActionScript(a);
        ASTranslatorTest.assertNotNull((Object)decoded);
        ASTranslatorTest.assertTrue((boolean)(decoded instanceof Map));
        Map amap = (Map)decoded;
        ASTranslatorTest.assertEquals((Object)"a-bar", amap.get("a-foo"));
        ASTranslatorTest.assertNotNull(amap.get("a-b"));
        ASTranslatorTest.assertTrue((boolean)(amap.get("a-b") instanceof Map));
        Map bmap = (Map)amap.get("a-b");
        ASTranslatorTest.assertNull(bmap.get("b-null"));
        ASTranslatorTest.assertEquals((Object)"b-bar", bmap.get("b-foo"));
    }

    public void testDecodeWithDesiredClass() throws Exception {
        Integer i = new Integer(10);
        Double d = new Double(10.0);
        Object encoded = new ASTranslator().toActionScript(i);
        ASTranslatorTest.assertTrue((boolean)(encoded instanceof Double));
        ASTranslatorTest.assertEquals((Object)d, (Object)encoded);
        Object decoded1 = new ASTranslator().fromActionScript(encoded);
        ASTranslatorTest.assertTrue((boolean)(decoded1 instanceof Double));
        ASTranslatorTest.assertEquals((Object)d, (Object)decoded1);
        Object decoded2 = new ASTranslator().fromActionScript(encoded, Integer.TYPE);
        ASTranslatorTest.assertTrue((boolean)(decoded2 instanceof Integer));
        ASTranslatorTest.assertEquals((Object)i, (Object)decoded2);
    }

    private void validateTestBean(TestBean bean, ASObject as) throws Exception {
        ASTranslatorTest.assertNotNull((Object)as);
        String msg = as.toString();
        ASTranslatorTest.assertEquals((String)msg, (String)(class$com$carbonfive$flash$test$TestBean == null ? (class$com$carbonfive$flash$test$TestBean = ASTranslatorTest.class$("com.carbonfive.flash.test.TestBean")) : class$com$carbonfive$flash$test$TestBean).getName(), (String)as.getType());
        ASTranslatorTest.assertTrue((String)msg, (boolean)as.containsKey((Object)"intField"));
        Object intField = as.get((Object)"intField");
        ASTranslatorTest.assertTrue((String)msg, (boolean)(intField instanceof Double));
        ASTranslatorTest.assertEquals((String)msg, (Object)new Double(bean.getIntField()), (Object)intField);
        ASTranslatorTest.assertTrue((String)msg, (boolean)as.containsKey((Object)"shortField"));
        Object shortField = as.get((Object)"shortField");
        ASTranslatorTest.assertTrue((String)msg, (boolean)(shortField instanceof Double));
        ASTranslatorTest.assertEquals((String)msg, (Object)new Double(bean.getShortField()), (Object)shortField);
        ASTranslatorTest.assertTrue((String)msg, (boolean)as.containsKey((Object)"longField"));
        Object longField = as.get((Object)"longField");
        ASTranslatorTest.assertTrue((String)msg, (boolean)(longField instanceof Double));
        ASTranslatorTest.assertEquals((String)msg, (Object)new Double(bean.getLongField()), (Object)longField);
        ASTranslatorTest.assertTrue((String)msg, (boolean)as.containsKey((Object)"doubleField"));
        Object doubleField = as.get((Object)"doubleField");
        ASTranslatorTest.assertTrue((String)msg, (boolean)(doubleField instanceof Double));
        ASTranslatorTest.assertEquals((String)msg, (Object)new Double(bean.getDoubleField()), (Object)doubleField);
        ASTranslatorTest.assertTrue((String)msg, (boolean)as.containsKey((Object)"strField"));
        Object strField = as.get((Object)"strField");
        ASTranslatorTest.assertTrue((String)msg, (boolean)(strField instanceof String));
        ASTranslatorTest.assertEquals((String)msg, (Object)bean.getStrField(), (Object)strField);
    }

    public void testCacheGetsEmptied() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class TestSuperBean2
    implements Serializable {
        private TestSuperBean bean;

        public TestSuperBean getBean() {
            return this.bean;
        }

        public void setBean(TestSuperBean bean) {
            this.bean = bean;
        }
    }

    public static class TestSuperBean
    extends TestBean {
    }

    public static class InfiniteLoopBean
    implements Serializable {
        private InfiniteLoopBean me;

        public InfiniteLoopBean getNewMe() {
            return new InfiniteLoopBean();
        }
    }

    public static class CircularTestBean
    implements Serializable {
        private CircularTestBean me;

        public CircularTestBean getMe() {
            return this.me;
        }

        public void setMe(CircularTestBean c) {
            this.me = c;
        }

        public boolean equals(Object obj) {
            return obj instanceof CircularTestBean;
        }

        public int hashCode() {
            return (class$com$carbonfive$flash$ASTranslatorTest$CircularTestBean == null ? (class$com$carbonfive$flash$ASTranslatorTest$CircularTestBean = ASTranslatorTest.class$("com.carbonfive.flash.ASTranslatorTest$CircularTestBean")) : class$com$carbonfive$flash$ASTranslatorTest$CircularTestBean).hashCode();
        }
    }

    public static class ComplexGenericTestBean
    implements Serializable {
        private List listField;
        private Map mapField;

        public List getListField() {
            return this.listField;
        }

        public void setListField(List l) {
            this.listField = l;
        }

        public Map getMapField() {
            return this.mapField;
        }

        public void setMapField(Map h) {
            this.mapField = h;
        }
    }

    public static class ComplexSpecificTestBean
    implements Serializable {
        private ArrayList listField;
        private HashMap mapField;

        public ArrayList getListField() {
            return this.listField;
        }

        public void setListField(ArrayList l) {
            this.listField = l;
        }

        public HashMap getMapField() {
            return this.mapField;
        }

        public void setMapField(HashMap h) {
            this.mapField = h;
        }
    }

    public static class DeepTestBean
    implements Serializable {
        private TestBean beanField;

        public TestBean getBeanField() {
            return this.beanField;
        }

        public void setBeanField(TestBean t) {
            this.beanField = t;
        }
    }
}

