/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.core.util;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.Kijimuna;
import org.seasar.kijimuna.core.preference.IPreferences;

/**
 * @author Masataka Kurihara (Gluegent, Inc.)
 */
public class MarkerUtils implements ConstCore {
    
    private static int getSystemSeverity(int severity) {
        switch(severity) {
        	case MARKER_SEVERITY_ERROR:
        	    return IMarker.SEVERITY_ERROR;
        	case MARKER_SEVERITY_WARNING:
        	    return IMarker.SEVERITY_WARNING;
        	case MARKER_SEVERITY_INFO:
        	    return IMarker.SEVERITY_INFO;
        	default:
        	    return -1;
        }
    }
    
    public static void createMarker(String type, String category, int severity,
            IResource resource, int line, String message) {
        if((severity == MARKER_SEVERITY_ERROR) ||
                (severity == MARKER_SEVERITY_WARNING) ||
                (severity == MARKER_SEVERITY_INFO)) {
	        try {
	    		IMarker marker = resource.createMarker(type);
	    		Map map = new HashMap(4);
	    		int systemSeverity = getSystemSeverity(severity);
	    		map.put(IMarker.SEVERITY, new Integer(systemSeverity));
	    		if (line < 1) {
	    		    line = 1;
	    		}
    			map.put(IMarker.LINE_NUMBER, new Integer(line));
	    		map.put(MARKER_ATTR_CATEGORY, category);
	    		map.put(IMarker.MESSAGE, message);
	    		marker.setAttributes(map);
	    	} catch (CoreException e) {
	    		Kijimuna.reportException(e);
	    	}
    	}
    }
    
	public static void deleteMarker(IResource resource, String type) {
    	try {
    		resource.deleteMarkers(
    		        type, true, IResource.DEPTH_INFINITE);
    	} catch (CoreException e) {
    		Kijimuna.reportException(e);
    	}
    }

	public static void removeAllMarker(String type) {
	    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		deleteMarker(root, type);
	}

    public static IMarker[] findMarker(IResource resource, String type) {
    	try {
    		return resource.findMarkers(
    		        type, true, IResource.DEPTH_INFINITE);
    	} catch (CoreException e) {
    		Kijimuna.reportException(e);
    		return new IMarker[0];
    	}
    }

	public static void changeMarkerSeverity(IResource resource,
			String type, IPreferences pref) {
		IMarker[] markers = findMarker(resource, type);
		for(int i = 0; i < markers.length; i++) {
	    	try {
	    		String category = (String)markers[i].getAttribute(
	    				MARKER_ATTR_CATEGORY);
	    		if(category != null) {
	    			int severity = pref.getInt(category);
	   				markers[i].setAttribute(IMarker.SEVERITY, 
	   						getSystemSeverity(severity));
	    		}
	    	} catch (CoreException e) {
	    		Kijimuna.reportException(e);
	    	}
		}
	}

}
