/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.core.rtti;

import java.util.regex.Pattern;

import org.eclipse.jdt.core.IType;

/**
 * @author Masataka Kurihara (Gluegent, Inc.)
 */
public class RttiWrapper implements IRtti {

    private IRtti rtti;
    
    public RttiWrapper(IRtti rtti) {
        this.rtti = rtti;
    }
    
    protected IRtti getWrappedRtti() {
        return rtti;
    }
    
    public boolean equals(Object obj) {
    	IRtti thisRtti = getWrappedRtti();
    	if(thisRtti != null) {
    		return thisRtti.equals(obj);
    	} else {
    		return false;
    	}
    }

    public int hashCode() {
    	IRtti thisRtti = getWrappedRtti();
    	if(thisRtti != null) {
    		return thisRtti.hashCode();
    	} else {
    		return super.hashCode();
    	}
    }
    
    public String toString() {
    	IRtti thisRtti = getWrappedRtti();
    	if(thisRtti != null) {
    		return thisRtti.toString();
    	} else {
    		return super.toString();
    	}
    }
    
    public Object getAdapter(Class adapter) {
    	IRtti thisRtti = getWrappedRtti();
    	if(thisRtti != null) {
    		return thisRtti.getAdapter(adapter);
    	} else {
    		return null;
    	}
    }
    
    public IType getType() {
    	IRtti thisRtti = getWrappedRtti();
    	if(thisRtti != null) {
    		return thisRtti.getType();
    	} else {
    		return null;
    	}
    }
    
    public RttiLoader getRttiLoader() {
    	IRtti thisRtti = getWrappedRtti();
    	if(thisRtti != null) {
    		return thisRtti.getRttiLoader();
    	} else {
    		return null;
    	}
    }
    
    public boolean isInterface() {
    	IRtti thisRtti = getWrappedRtti();
    	if(thisRtti != null) {
    		return thisRtti.isInterface();
    	} else {
    		return false;
    	}
    }
    
    public boolean isFinal() {
    	IRtti thisRtti = getWrappedRtti();
    	if(thisRtti != null) {
    		return thisRtti.isFinal();
    	} else {
    		return false;
    	}
    }
    
    public boolean isAssignableFrom(IRtti testRtti) {
    	IRtti thisRtti = getWrappedRtti();
    	if(thisRtti != null) {
    		return thisRtti.isAssignableFrom(testRtti);
    	} else {
    		return false;
    	}
    }
    
    public String getQualifiedName() {
    	IRtti thisRtti = getWrappedRtti();
    	if(thisRtti != null) {
    		return thisRtti.getQualifiedName();
    	} else {
    		return null;
    	}
    }
    
    public String getShortName() {
    	IRtti thisRtti = getWrappedRtti();
    	if(thisRtti != null) {
    		return thisRtti.getShortName();
    	} else {
    		return null;
    	}
    }
    
    public IRtti[] getInterfaces() {
    	IRtti thisRtti = getWrappedRtti();
    	if(thisRtti != null) {
    		return thisRtti.getInterfaces();
    	} else {
    		return new IRtti[0];
    	}
    }
    
    public IRtti getSuperClass() {
    	IRtti thisRtti = getWrappedRtti();
    	if(thisRtti != null) {
    		return thisRtti.getSuperClass();
    	} else {
    		return null;
    	}
    }
    
    public IRttiFieldDescriptor getField(String field, boolean staticAccess) {
    	IRtti thisRtti = getWrappedRtti();
    	if(thisRtti != null) {
    		return thisRtti.getField(field, staticAccess);
    	} else {
    		return null;
    	}
    }

	public IRttiConstructorDesctiptor getConstructor(IRtti[] args) {
    	IRtti thisRtti = getWrappedRtti();
    	if(thisRtti != null) {
    		return thisRtti.getConstructor(args);
    	} else {
    		return null;
    	}
	}
    
    public IRttiConstructorDesctiptor[] getConstructors() {
    	IRtti thisRtti = getWrappedRtti();
    	if(thisRtti != null) {
    		return thisRtti.getConstructors();
    	} else {
    		return new IRttiConstructorDesctiptor[0];
    	}
    }

	public IRttiMethodDesctiptor getMethod(
	        String name, IRtti[] args, boolean staticAccess) {
    	IRtti thisRtti = getWrappedRtti();
    	if(thisRtti != null) {
    		return thisRtti.getMethod(name, args, staticAccess);
    	} else {
    		return null;
    	}
	}
    
    public IRttiMethodDesctiptor[] getMethods(Pattern pattern) {
    	IRtti thisRtti = getWrappedRtti();
    	if(thisRtti != null) {
    		return thisRtti.getMethods(pattern);
    	} else {
    		return new IRttiMethodDesctiptor[0];
    	}
    }
	
	public IRttiPropertyDescriptor getProperty(String name) {
    	IRtti thisRtti = getWrappedRtti();
    	if(thisRtti != null) {
    		return thisRtti.getProperty(name);
    	} else {
    		return null;
    	}
    }

	public IRttiPropertyDescriptor[] getProperties() {
    	IRtti thisRtti = getWrappedRtti();
    	if(thisRtti != null) {
    		return thisRtti.getProperties();
    	} else {
    		return new IRttiPropertyDescriptor[0];
    	}
	}

}
