/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.core.rtti;

import java.util.HashSet;
import java.util.Set;

/**
 * @author Masataka Kurihara (Gluegent, Inc.)
 */
class DefaultRttiPropertyDescriptor extends AbstractRttiValuableDescriptor 
	implements IRttiPropertyDescriptor {

    private Set writableType;
    private boolean readable;
    private boolean writable;
    
    DefaultRttiPropertyDescriptor(
            IRtti parent, String name, IRtti type, boolean isReadable) {
        super(parent, name, type);
        if(isReadable) {
            readable = true;
        } else {
            writable = true;
        }
        writableType = new HashSet();
    }
    
    public void doReadable(IRtti type) {
        if(!readable || type.getQualifiedName().equals("boolean")) {
            setType(type);
        }
        readable = true;
        writable = writableType.contains(type);
    }
    
    public void doWritable(IRtti type) {
        if((readable) && getType().equals(type)) {
            writable = true;
        }
        writableType.add(type);
    }

	public boolean equals(Object test) {
        if(test instanceof IRttiPropertyDescriptor) {
            IRttiPropertyDescriptor desc = (IRttiPropertyDescriptor)test;
            return getParent().equals(desc.getParent()) &&
            	getName().equals(desc.getName());
        } else {
            return false;
        }
    }
    
    public boolean isReadable() {
        return readable;
    }

    public boolean isWritable() {
        return writable;
    }
    
    public int compareTo(Object test) {
        if(test instanceof IRttiPropertyDescriptor) {
        	IRttiPropertyDescriptor prop = (IRttiPropertyDescriptor)test;
        	return getName().compareTo(prop.getName());
        } else {
        	return 1;
        }
    }
}
