
package org.seasar.kijimuna.core.preference;

/**
 * @author Masataka Kurihara (Gluegent, Inc.)
 */
public interface IPreferences {

	public String getDefault(String key);
	public boolean getDefaultBoolean(String key);
	public byte[] getDefaultByteArray(String key);
	public double getDefaultDouble(String key);
	public float getDefaultFloat(String key);
	public int getDefaultInt(String key);
	public long getDefaultLong(String key);
	public void putDefault(String key, String value);
	public void putDefaultBoolean(String key, boolean value);
	public void putDefaultByteArray(String key, byte[] value);
	public void putDefaultDouble(String key, double value);
	public void putDefaultFloat(String key, float value);
	public void putDefaultInt(String key, int value);
	public void putDefaultLong(String key, long value);
	public void removeDefault(String key);
	public void clearDefault();
	
	public String get(String key);
	public boolean getBoolean(String key);
	public byte[] getByteArray(String key);
	public double getDouble(String key);
	public float getFloat(String key);
	public int getInt(String key);
	public long getLong(String key);
	public void put(String key, String value);
	public void putBoolean(String key, boolean value);
	public void putByteArray(String key, byte[] value);
	public void putDouble(String key, double value);
	public void putFloat(String key, float value);
	public void putInt(String key, int value);
	public void putLong(String key, long value);
	public void remove(String key);
	public void clear();
	
	public void flash();
}
