/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.core;

import java.net.URL;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.Preferences;
import org.seasar.kijimuna.core.preference.IPreferences;
import org.seasar.kijimuna.core.preference.KijimunaPreferences;
import org.seasar.kijimuna.core.project.ProjectRecorder;
import org.seasar.kijimuna.core.util.FileUtils;
import org.seasar.kijimuna.core.util.MarkerUtils;

/**
 * @author Masataka Kurihara (Gluegent, Inc)
 */
public class Kijimuna extends Plugin implements ConstCore {

	//	 static
	// -------------------------------------------------------------------

	private static Kijimuna kijimuna;
	private static IPreferences preferences;

	public static Kijimuna getInstance() {
	    return kijimuna;
	}
	
	public static void reportInfo(String message) {
		kijimuna.messageManager.reportInfo(message);
	}
	
	public static void reportException(Exception e) {
		kijimuna.messageManager.reportException(e);
	}

	public static String getResourceString(String key) {
		return kijimuna.messageManager.getResourceString(key);
	}
	
	public static String getResourceString(String key, Object[] args) {
		return kijimuna.messageManager.getResourceString(key, args);
	}

	public static URL getEntry(String path) {
		return kijimuna.getBundle().getEntry(path);
	}

	public static ProjectRecorder getProjectRecorder() {
	    return kijimuna.recorder;
	}
	
	public static String getVersion() {
        return kijimuna.getBundle().getHeaders().get("Bundle-Version").toString();
	}
	
	public static IPreferences getPreferences() {
	    if(preferences == null) {
	        preferences = new KijimunaPreferences();
	        String version = preferences.get(PREFERENCES_KEY_VERSION);
	        if(!version.equals(Kijimuna.getVersion())) {
	            preferences.clear();
	    		preferences.put(PREFERENCES_KEY_VERSION, Kijimuna.getVersion());
	    		initPluginData();
	        }
	    }
	    return preferences;
	}
	
	private static void initPluginData() {
        MarkerUtils.removeAllMarker(ID_MARKER);
        FileUtils.deleteAllFiles(kijimuna.getStateLocation());
	}
	
	//	 instance
	// -------------------------------------------------------------------

	private ProjectRecorder recorder;
	private MessageManager messageManager;
	
	public Kijimuna() {
		super();
		kijimuna = this;
		messageManager = new MessageManager(this, PATH_RESOURCE);
	}
    
    public void start(BundleContext context) throws Exception {
        super.start(context);
        getPreferences();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        recorder = new ProjectRecorder(this);
        recorder.inithialize(null);
        workspace.addSaveParticipant(this, recorder);
    }
    
	public void stop(BundleContext context) throws Exception {
		IScopeContext scope = new InstanceScope();
		Preferences pref = scope.getNode(ID_PLUGIN_CORE);
		pref.flush();
		Preferences pluginPref = 
			Platform.getPreferencesService().getRootNode().node("plugin");
		pluginPref.flush();
		super.stop(context);
	}
}