/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.ui.preference.design;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

/**
* This code was generated using CloudGarden's Jigloo
* SWT/Swing GUI Builder, which is free for non-commercial
* use. If Jigloo is being used commercially (ie, by a corporation,
* company or business for any purpose whatever) then you
* should purchase a license for each developer using Jigloo.
* Please visit www.cloudgarden.com for details.
* Use of Jigloo implies acceptance of these licensing terms.
* *************************************
* A COMMERCIAL LICENSE HAS NOT BEEN PURCHASED
* for this machine, so Jigloo or this code cannot be used legally
* for any corporate or commercial purpose.
* *************************************
*/
public class ProjectPropertyGUI extends Composite {

	private Label markerLabel;
	private Button natureCheck;
	private TabFolder tabFolder;
	private TabItem markerTabItem;
	private Composite markerComposite;

	private Label xmlErrorLabel;
	private Label xmlWarningLabel;
	private Label nullInjectionLabel;
	private Label autoInjectionLabel;
	private Label javaFetalLabel;
	private Label diconFetalLabel;
	private Label problemDiconLabel;

	private Combo xmlErrorCombo;
	private Combo xmlWarningCombo;
	private Combo nullInjectionCombo;
	private Combo autoInjectionCombo;
	private Combo javaFetalCombo;
	private Combo diconFetalCombo;
	private Combo diconProblemCombo;
	
	public ProjectPropertyGUI(Composite parent, int style) {
		super(parent, style);
		initGUI();
	}

	public void initGUI(){
		try {
			preInitGUI();
	
			natureCheck = new Button(this,SWT.CHECK| SWT.LEFT);
			tabFolder = new TabFolder(this,SWT.NULL);
			markerTabItem = new TabItem(tabFolder,SWT.NULL);
			markerComposite = new Composite(tabFolder,SWT.NULL);
			markerLabel = new Label(markerComposite,SWT.NULL);
			xmlErrorLabel = new Label(markerComposite,SWT.NULL);
			xmlErrorCombo = new Combo(markerComposite,SWT.READ_ONLY);
			xmlWarningLabel = new Label(markerComposite,SWT.NULL);
			xmlWarningCombo = new Combo(markerComposite,SWT.READ_ONLY);
			nullInjectionLabel = new Label(markerComposite,SWT.NULL);
			nullInjectionCombo = new Combo(markerComposite,SWT.READ_ONLY);
			autoInjectionLabel = new Label(markerComposite,SWT.NULL);
			autoInjectionCombo = new Combo(markerComposite,SWT.READ_ONLY);
			javaFetalLabel = new Label(markerComposite,SWT.NULL);
			javaFetalCombo = new Combo(markerComposite,SWT.READ_ONLY);
			diconFetalLabel = new Label(markerComposite,SWT.NULL);
			diconFetalCombo = new Combo(markerComposite,SWT.READ_ONLY);
			problemDiconLabel = new Label(markerComposite,SWT.NULL);
			diconProblemCombo = new Combo(markerComposite,SWT.READ_ONLY);
	
			this.setSize(new org.eclipse.swt.graphics.Point(380,290));
	
			GridData natureCheckLData = new GridData();
			natureCheckLData.verticalAlignment = GridData.FILL;
			natureCheckLData.horizontalAlignment = GridData.FILL;
			natureCheckLData.widthHint = -1;
			natureCheckLData.heightHint = -1;
			natureCheckLData.horizontalIndent = 0;
			natureCheckLData.horizontalSpan = 3;
			natureCheckLData.verticalSpan = 3;
			natureCheckLData.grabExcessHorizontalSpace = false;
			natureCheckLData.grabExcessVerticalSpace = false;
			natureCheck.setLayoutData(natureCheckLData);
			natureCheck.setText(Messages.getString("ProjectPropertyGUI.0")); //$NON-NLS-1$
			natureCheck.setSize(new org.eclipse.swt.graphics.Point(370,16));
			natureCheck.setEnabled(true);
			natureCheck.addSelectionListener( new SelectionAdapter() {
				public void widgetSelected(SelectionEvent evt) {
					natureCheckWidgetSelected(evt);
				}
			});
	
			GridData tabFolderLData = new GridData();
			tabFolderLData.verticalAlignment = GridData.FILL;
			tabFolderLData.horizontalAlignment = GridData.FILL;
			tabFolderLData.widthHint = -1;
			tabFolderLData.heightHint = -1;
			tabFolderLData.horizontalIndent = 0;
			tabFolderLData.horizontalSpan = 1;
			tabFolderLData.verticalSpan = 1;
			tabFolderLData.grabExcessHorizontalSpace = false;
			tabFolderLData.grabExcessVerticalSpace = true;
			tabFolder.setLayoutData(tabFolderLData);
			tabFolder.setSize(new org.eclipse.swt.graphics.Point(362,251));
	
			markerTabItem.setControl(markerComposite);
			markerTabItem.setText(Messages.getString("ProjectPropertyGUI.1")); //$NON-NLS-1$
	
			markerComposite.setSize(new org.eclipse.swt.graphics.Point(362,234));
	
			GridData markerLabelLData = new GridData();
			markerLabelLData.widthHint = 230;
			markerLabelLData.heightHint = 12;
			markerLabelLData.horizontalSpan = 2;
			markerLabelLData.grabExcessHorizontalSpace = true;
			markerLabel.setLayoutData(markerLabelLData);
			markerLabel.setText(Messages.getString("ProjectPropertyGUI.2")); //$NON-NLS-1$
			markerLabel.setSize(230, 12);
	
			GridData xmlErrorLabelLData = new GridData();
			xmlErrorLabelLData.widthHint = 230;
			xmlErrorLabelLData.heightHint = 12;
			xmlErrorLabelLData.grabExcessHorizontalSpace = true;
			xmlErrorLabel.setLayoutData(xmlErrorLabelLData);
			xmlErrorLabel.setText(Messages.getString("ProjectPropertyGUI.3")); //$NON-NLS-1$
			xmlErrorLabel.setSize(230, 12);
	
			GridData xmlErrorComboLData = new GridData();
			xmlErrorComboLData.horizontalAlignment = GridData.END;
			xmlErrorComboLData.widthHint = 49;
			xmlErrorComboLData.heightHint = 20;
			xmlErrorCombo.setLayoutData(xmlErrorComboLData);
			xmlErrorCombo.setSize(49, 20);
	
			GridData xmlWarningLabelLData = new GridData();
			xmlWarningLabel.setSize(230, 12);
			xmlWarningLabelLData.widthHint = 230;
			xmlWarningLabelLData.heightHint = 12;
			xmlWarningLabelLData.grabExcessHorizontalSpace = true;
			xmlWarningLabel.setLayoutData(xmlWarningLabelLData);
			xmlWarningLabel.setText(Messages.getString("ProjectPropertyGUI.4")); //$NON-NLS-1$

			GridData xmlWarningComboLData = new GridData();
			xmlWarningComboLData.horizontalAlignment = GridData.END;
			xmlWarningComboLData.widthHint = 49;
			xmlWarningComboLData.heightHint = 20;
			xmlWarningCombo.setLayoutData(xmlWarningComboLData);
			xmlWarningCombo.setSize(49, 20);
	
			GridData nullInjectionLabelLData = new GridData();
			nullInjectionLabelLData.widthHint = 230;
			nullInjectionLabelLData.heightHint = 12;
			nullInjectionLabelLData.grabExcessHorizontalSpace = true;
			nullInjectionLabel.setLayoutData(nullInjectionLabelLData);
			nullInjectionLabel.setText(Messages.getString("ProjectPropertyGUI.5")); //$NON-NLS-1$

			GridData nullInjectionComboLData = new GridData();
			nullInjectionComboLData.horizontalAlignment = GridData.END;
			nullInjectionComboLData.widthHint = 49;
			nullInjectionComboLData.heightHint = 20;
			nullInjectionCombo.setLayoutData(nullInjectionComboLData);
			nullInjectionCombo.setSize(49, 20);
	
			GridData autoInjectionLabelLData = new GridData();
			autoInjectionLabelLData.widthHint = 230;
			autoInjectionLabelLData.heightHint = 12;
			autoInjectionLabelLData.grabExcessHorizontalSpace = true;
			autoInjectionLabel.setLayoutData(autoInjectionLabelLData);
			autoInjectionLabel.setText(Messages.getString("ProjectPropertyGUI.6")); //$NON-NLS-1$
			autoInjectionLabel.setSize(230, 12);
	
			GridData autoInjectionComboLData = new GridData();
			autoInjectionComboLData.horizontalAlignment = GridData.END;
			autoInjectionComboLData.widthHint = 49;
			autoInjectionComboLData.heightHint = 20;
			autoInjectionCombo.setLayoutData(autoInjectionComboLData);
			autoInjectionCombo.setSize(49, 20);
	
			GridData javaFetalLabelLData = new GridData();
			javaFetalLabelLData.widthHint = 230;
			javaFetalLabelLData.heightHint = 12;
			javaFetalLabelLData.grabExcessHorizontalSpace = true;
			javaFetalLabel.setLayoutData(javaFetalLabelLData);
			javaFetalLabel.setText(Messages.getString("ProjectPropertyGUI.7")); //$NON-NLS-1$
			javaFetalLabel.setSize(230, 12);
	
			GridData javaFetalComboLData = new GridData();
			javaFetalComboLData.horizontalAlignment = GridData.END;
			javaFetalComboLData.widthHint = 49;
			javaFetalComboLData.heightHint = 20;
			javaFetalCombo.setLayoutData(javaFetalComboLData);
			javaFetalCombo.setSize(49, 20);
	
			GridData diconFetalLabelLData = new GridData();
			diconFetalLabelLData.widthHint = 230;
			diconFetalLabelLData.heightHint = 12;
			diconFetalLabelLData.grabExcessHorizontalSpace = true;
			diconFetalLabel.setLayoutData(diconFetalLabelLData);
			diconFetalLabel.setText(Messages.getString("ProjectPropertyGUI.8")); //$NON-NLS-1$
			diconFetalLabel.setSize(230, 12);
	
			GridData diconFetalComboLData = new GridData();
			diconFetalComboLData.horizontalAlignment = GridData.END;
			diconFetalComboLData.widthHint = 49;
			diconFetalComboLData.heightHint = 20;
			diconFetalCombo.setLayoutData(diconFetalComboLData);
			diconFetalCombo.setSize(49, 20);
	
			GridData problemDiconLabelLData = new GridData();
			problemDiconLabelLData.widthHint = 230;
			problemDiconLabelLData.heightHint = 12;
			problemDiconLabelLData.grabExcessHorizontalSpace = true;
			problemDiconLabel.setLayoutData(problemDiconLabelLData);
			problemDiconLabel.setText(Messages.getString("ProjectPropertyGUI.9")); //$NON-NLS-1$
			problemDiconLabel.setSize(230, 12);
	
			GridData diconProblemComboLData = new GridData();
			diconProblemComboLData.horizontalAlignment = GridData.END;
			diconProblemComboLData.widthHint = 49;
			diconProblemComboLData.heightHint = 20;
			diconProblemCombo.setLayoutData(diconProblemComboLData);
			diconProblemCombo.setSize(49, 20);
			GridLayout markerCompositeLayout = new GridLayout(2, true);
			markerComposite.setLayout(markerCompositeLayout);
			markerCompositeLayout.marginWidth = 5;
			markerCompositeLayout.marginHeight = 5;
			markerCompositeLayout.numColumns = 2;
			markerCompositeLayout.makeColumnsEqualWidth = true;
			markerCompositeLayout.horizontalSpacing = 5;
			markerCompositeLayout.verticalSpacing = 5;
			markerComposite.layout();
			GridLayout thisLayout = new GridLayout(1, true);
			this.setLayout(thisLayout);
			thisLayout.marginWidth = 5;
			thisLayout.marginHeight = 5;
			thisLayout.numColumns = 1;
			thisLayout.makeColumnsEqualWidth = true;
			thisLayout.horizontalSpacing = 5;
			thisLayout.verticalSpacing = 5;
			this.layout();
	
			postInitGUI();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	public void preInitGUI(){
	}

	public void postInitGUI(){
	}
	
	public Button getNatureCheck() {
	    return natureCheck;
	}
	
	public TabFolder getTabFolder() {
	    return tabFolder;
	}

	public Combo getXmlErrorCombo() {
	    return xmlErrorCombo;
	}
	
	public Combo getXmlWarningCombo() {
	    return xmlWarningCombo;
	}
	
	public Combo getNullInjectionCombo() {
	    return nullInjectionCombo;
	}
	
	public Combo getAutoInjectionCombo() {
	    return autoInjectionCombo;
	}
	
	public Combo getJavaFetalCombo() {
	    return javaFetalCombo;
	}
	
	public Combo getDiconFetalCombo() {
	    return diconFetalCombo;
	}
	
	public Combo getDiconProblemCombo() {
	    return diconProblemCombo;
	}

	protected void natureCheckWidgetSelected(SelectionEvent evt){
	    tabFolder.setEnabled(natureCheck.getSelection());
	}
}
