/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.ui.dicon.wizard;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.seasar.kijimuna.core.util.FileUtils;
import org.seasar.kijimuna.core.util.StringUtils;
import org.seasar.kijimuna.ui.ConstUI;
import org.seasar.kijimuna.ui.KijimunaUI;
import org.seasar.kijimuna.ui.util.WorkbenchUtils;

/**
 * @author Masataka Kurihara (Gluegent, Inc.)
 */
public class NewDiconWizardPage extends NewTypeWizardPage
	implements ModifyListener, ConstUI {
    
    private Text nameText;
    private Combo encodingCombo;
    
    public NewDiconWizardPage(String pageName) {
        super(false, pageName);
        setTitle(KijimunaUI.getResourceString("dicon.wizard.NewDiconWizardPage.1"));
        setDescription(KijimunaUI.getResourceString("dicon.wizard.NewDiconWizardPage.2"));
        setPageComplete(false);
    }

    public void createControl(Composite parent) {
		initializeDialogUnits(parent);
		Composite composite= new Composite(parent, SWT.NONE);
		final int nColumns= 4;
		GridLayout layout= new GridLayout();
		layout.numColumns= nColumns;		
		composite.setLayout(layout);
		createContainerControls(composite, nColumns);	
		createPackageControls(composite, nColumns);	
		Label nameLabel = new Label(composite, SWT.NONE);
        nameLabel.setText(
                KijimunaUI.getResourceString("dicon.wizard.NewDiconWizardPage.3"));
        nameText = new Text(composite, SWT.SINGLE | SWT.BORDER);
        GridData text1LData1 = new GridData();
        text1LData1.horizontalAlignment = GridData.FILL;
        text1LData1.grabExcessHorizontalSpace = true;
        nameText.setLayoutData(text1LData1);
        nameText.addModifyListener(this);
        Label nullLabel = new Label(composite, SWT.NONE);
        GridData nullLabelLData = new GridData();
        nullLabelLData.horizontalSpan = 2;
        nullLabelLData.horizontalAlignment = GridData.FILL;
        nullLabel.setLayoutData(nullLabelLData);
		Label encodingLabel = new Label(composite, SWT.NONE);
        encodingLabel.setText(
                KijimunaUI.getResourceString("dicon.wizard.NewDiconWizardPage.4"));
        encodingCombo = new Combo(composite, SWT.NONE);
        initEncodingCombo(encodingCombo);
        encodingCombo.addModifyListener(this);
		setControl(composite);
		Dialog.applyDialogFont(composite);
    }
	
    private void initEncodingCombo(Combo combo) {
        String setting = WorkbenchUtils.getWorkbenchEncoding();
        combo.setText(setting);
        if(combo.getItemCount() == 0) {
	        String[] encodings = WorkbenchUtils.getAllWorkbenchEncodings();
	        for(int i = 0; i < encodings.length; i++) {
	            combo.add(encodings[i]);
	        }
        }
    }

	public void init(IStructuredSelection selection) {
		IJavaElement jelem= getInitialJavaElement(selection);
		initContainerPage(jelem);
		initTypePage(jelem);
	}		

	private IStatus createStatus(int severity, String message) {
	    return new Status(severity, ID_PLUGIN_UI, IStatus.OK, message, null);
	}
	
	private IStatus createNameStatus() {
	    int severity = IStatus.ERROR;
	    String message = "";
	    if(nameText != null) {
		    String name = nameText.getText();
		    if(StringUtils.noneValue(name)) {
	            message = KijimunaUI.getResourceString("dicon.wizard.NewDiconWizardPage.5");
		    } else {
		        severity = IStatus.OK;
		    }
	    }
	    return createStatus(severity, message);
	}

	private IStatus createEncodingStatus() {
	    int severity = IStatus.ERROR;
	    String message = "";
	    if(encodingCombo != null) {
		    String enc = encodingCombo.getText();
		    if(StringUtils.noneValue(enc)) {
	            message = KijimunaUI.getResourceString("dicon.wizard.NewDiconWizardPage.6");
		    } else {
		    	try {
		    		String test = "enc test string";
		    		test.getBytes(enc);
		    		severity = IStatus.OK;
		    	} catch(UnsupportedEncodingException e) {
		            message = KijimunaUI.getResourceString("dicon.wizard.NewDiconWizardPage.7");
		    	}
		    }
	    }
	    return createStatus(severity, message);
	}

	private IStatus createPackageExistStatus() {
	    int severity = IStatus.ERROR;
	    String message = "";
        IPackageFragment pack = getPackageFragment();
	    if(pack.exists()) {
	        severity = IStatus.OK;
	    } else {
            message = KijimunaUI.getResourceString("dicon.wizard.NewDiconWizardPage.8");
	    }
	    return createStatus(severity, message);
	}
	
	private void doStatusUpdate() {
	    IStatus nameStatus = createNameStatus();
	    IStatus encodingStatus = createEncodingStatus();
	    IStatus packageExist = createPackageExistStatus();
		IStatus[] status= new IStatus[] {
			fContainerStatus,
			fPackageStatus,
			nameStatus,
			encodingStatus,
			packageExist
		};
		updateStatus(status);
	}

    public void modifyText(ModifyEvent e) {
        doStatusUpdate();
    }

    protected void handleFieldChanged(String fieldName) {
		super.handleFieldChanged(fieldName);
		doStatusUpdate();
	}

	public void setVisible(boolean visible) {
		super.setVisible(visible);
		if (visible) {
			nameText.setFocus();
		}
	}	
	
    public boolean createDiconFile() {
        IPackageFragment pack = getPackageFragment();
        String name = nameText.getText();
        if(!name.endsWith("." + EXT_DICON)) {
        	name = name + "." + EXT_DICON;
        }
        String enc = encodingCombo.getText();
        String dicon = "<?xml version=\"1.0\" encoding=\"" + enc + "\"?>\r\n" +
			"<!DOCTYPE components PUBLIC \"-//SEASAR//DTD S2Container//EN\"\r\n" +
			"\t\"http://www.seasar.org/dtd/components.dtd\">\r\n" +
			"<components>\r\n\r\n\t<component class=\"java.util.ArrayList\">\r\n" +
			"\t\t\r\n\t</component>\r\n\r\n</components>\r\n";
        try {
			InputStream contents = new ByteArrayInputStream(dicon.getBytes(enc));
			IFile file = FileUtils.createFile(pack, name, contents);
			if(file != null) {
				WorkbenchUtils.openDiconEditor(file);
				return true;
			}
		} catch (UnsupportedEncodingException e) {
			KijimunaUI.reportException(e);
		}
		return false;
    }
    
}
