/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.ui.dicon.view;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.seasar.kijimuna.core.parser.Element;
import org.seasar.kijimuna.ui.dicon.provider.DiconContentProvider;
import org.seasar.kijimuna.ui.dicon.provider.DiconLabelProvider;
import org.seasar.kijimuna.ui.dicon.provider.IInternalContainer;
import org.seasar.kijimuna.ui.dicon.provider.walker.ViewContent;
import org.seasar.kijimuna.ui.util.WorkbenchUtils;

/**
 * @author Masataka Kurihara (Gluegent, Inc.)
 */
public class DiconTreeView extends ViewPart
		implements ISelectionChangedListener, IPartListener, IDoubleClickListener {

	private TreeViewer viewer;
	private ISelectionProvider selectionProvider;
	private IWorkbenchPart focusPart;
	private IProject currentProject;
	
	public void createPartControl(Composite parent) {
		viewer = new TreeViewer(parent, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);
        viewer.setContentProvider(new DiconContentProvider());
        viewer.setLabelProvider(new DiconLabelProvider());
        viewer.setAutoExpandLevel(1);
        viewer.addDoubleClickListener(this);
        getSite().setSelectionProvider(viewer);
        getViewSite().setSelectionProvider(viewer);
        initInput();
        getSite().getPage().addPartListener(this);
 	}
	
	private void initInput() {
		IWorkbenchPart part =  WorkbenchUtils.getActiveEditor();
		if(part == null) {
			part = WorkbenchUtils.getWorkbenchPart();
		}
		partActivated(part);
	}
	
	private void setInput(IProject project) {
    	if(project != null) {
    		if( !project.equals(currentProject)) {
	    		currentProject = project;
	    		viewer.setInput(new ViewContent(project));
    		}
    	}
	}
	
	public void setFocus() {
	    viewer.getTree().setFocus();
	}
	
	public void dispose() {
		if(selectionProvider != null) {
			selectionProvider.removeSelectionChangedListener(this);
		}
		getSite().getPage().removePartListener(this);
		super.dispose();
	}
	
	public void doubleClick(DoubleClickEvent event) {
		Object obj = WorkbenchUtils.getFirstSelectedElement(event.getSelection());
		WorkbenchUtils.showSource(WorkbenchUtils.getActiveEditor(), obj);
	}

	public void selectionChanged(SelectionChangedEvent event) {
		if(focusPart == this) {
		    IEditorPart editorPart = WorkbenchUtils.getActiveEditor();
		    if(editorPart != null) {
		        IStorage displayFile = WorkbenchUtils.getInputResource(editorPart);
		        if(displayFile != null) {
		    		Object obj = WorkbenchUtils.getFirstSelectedElement(event.getSelection());
			        if(obj instanceof IInternalContainer) {
			            Element element = ((IInternalContainer)obj).getElement();
			            if(element != null) {
				            IStorage selectedFile = (IStorage)element.getAdapter(IStorage.class);
				            if(displayFile.equals(selectedFile)) {
				                WorkbenchUtils.moveLine(editorPart, element.getStartLine());
				            }
			            }
			        }
		        }
		    }
		} else {
		    if(selectionProvider != null) {
				setInput(WorkbenchUtils.getCurrentProject(
				        selectionProvider.getSelection()));
			}
		}
    }

	public void partActivated(IWorkbenchPart part) {
		if((part != null) && (part != focusPart)) {
			if (selectionProvider != null) {
				selectionProvider.removeSelectionChangedListener(this);
				selectionProvider = null;
			}
			if(focusPart != part) {
				focusPart = part;
				if (focusPart != null) {
					if(focusPart instanceof IEditorPart) {
						IEditorPart editorPart = (IEditorPart)focusPart;
						IStorage storage = WorkbenchUtils.getInputResource(editorPart);
					    if(storage instanceof IFile) {
					    	IFile file = (IFile)storage;
							setInput(file.getProject());
							return;
					    } else {
					    	// currentProject
					    	return;
					    }
					}
					selectionProvider = focusPart.getSite().getSelectionProvider();
					if (selectionProvider != null) {
						selectionProvider.addSelectionChangedListener(this);
						setInput(WorkbenchUtils.getCurrentProject(
								selectionProvider.getSelection()));
						return;
					}
				}
			}
			setInput(null);
		}
	}

	public void partClosed(IWorkbenchPart part) {
		if (part == focusPart) {
			if (selectionProvider != null) {
				selectionProvider.removeSelectionChangedListener(this);
				selectionProvider = null;
			}
			focusPart = null;
		}
	}

	public void partOpened(IWorkbenchPart part) {
	}

	public void partBroughtToTop(IWorkbenchPart part) {
	}

	public void partDeactivated(IWorkbenchPart part) {
	}

}
