/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.ui.dicon.provider.property;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.dicon.info.IDirectAccessed;
import org.seasar.kijimuna.core.dicon.model.ContainerElement;
import org.seasar.kijimuna.core.dicon.model.DiconElement;
import org.seasar.kijimuna.core.rtti.HasErrorRtti;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.util.ModelUtils;
import org.seasar.kijimuna.ui.KijimunaUI;

/**
 * @author Masataka Kurihara (Gluegent, Inc.)
 */
public class ContentProperty extends NullProperty
		implements ConstCore {

    private static Map descriptorsMap;

    private static void descSetting(Map map, String tag, String[] id) {
        IPropertyDescriptor[] desc = new IPropertyDescriptor[id.length];
        for(int i = 0; i < id.length; i++) {
            String display;
            String category;
            if(DICON_BODY.equals(id[i])) {
                // expression
                display = KijimunaUI.getResourceString(
                        "dicon.provider.property.ContentProperty.1");
                category = KijimunaUI.getResourceString(
                	"dicon.provider.property.ContentProperty.4");
            } else if(DICON_ATTR_PATH.equals(id[i])) {
                // path
                display = KijimunaUI.getResourceString(
                	"dicon.provider.property.ContentProperty.2");
                category = KijimunaUI.getResourceString(
                	"dicon.provider.property.ContentProperty.4");
            } else if(DICON_INJECTED_VALUE.equals(id[i])) {
            	// injected value
                display = KijimunaUI.getResourceString(
            		"dicon.provider.property.ContentProperty.5");
                category = KijimunaUI.getResourceString(
                	"dicon.provider.property.ContentProperty.4");
            } else {
                // xml attributes
                display = id[i];
                category = KijimunaUI.getResourceString(
                "dicon.provider.property.ContentProperty.3");
            }
            PropertyDescriptor d = new PropertyDescriptor(id[i], display);
            d.setCategory(category);
            desc[i] = d;
        }
        map.put(tag, desc);
    }
    
    static {
        descriptorsMap = new HashMap();
        descSetting(descriptorsMap, DICON_TAG_ARG, DICON_ATTRS_ARG); 
        descSetting(descriptorsMap, DICON_TAG_ASPECT, DICON_ATTRS_ASPECT); 
        descSetting(descriptorsMap, DICON_TAG_COMPONENT, DICON_ATTRS_COMPONENT); 
        descSetting(descriptorsMap, DICON_TAG_CONTAINER, DICON_ATTRS_CONTAINER); 
        descSetting(descriptorsMap, DICON_TAG_DESTROYMETHOD, DICON_ATTRS_DESTROYMETHOD); 
        descSetting(descriptorsMap, DICON_TAG_INITMETHOD, DICON_ATTRS_INITMETHOD); 
        descSetting(descriptorsMap, DICON_TAG_PROPERTY, DICON_ATTRS_PROPERTY); 
    }
    
    private DiconElement element;
    
	public ContentProperty(DiconElement element) {
	    this.element = element;
	}
    
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return (IPropertyDescriptor[])descriptorsMap.get(element.getElementName());
	}
	
	public Object getPropertyValue(Object id) {
	    if(DICON_BODY.equals(id)) {
	        return element.getExpression();
	    } else if((element instanceof ContainerElement) &&
	    		DICON_ATTR_PATH.equals(id)) {
	    	return ((ContainerElement)element).getPath();
	    } else if(DICON_INJECTED_VALUE.equals(id)) {
	        IRtti rtti = (IRtti)element.getAdapter(IRtti.class);
	        if(rtti != null) {
	            if(rtti instanceof HasErrorRtti) {
	                return ((HasErrorRtti)rtti).getErrorMessage();
	            } else if(rtti instanceof IDirectAccessed) {
	                return ModelUtils.getInjectedElementName(rtti);
	            }
	        }
	        return null;
	    }
		return element.getAttribute(id.toString());
	}
	
}
