/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.ui;

import java.net.URL;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.internal.ui.SharedImages;
import org.eclipse.jdt.ui.ISharedImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.seasar.kijimuna.core.MessageManager;

/**
 * @author Masataka Kurihara (Gluegent, Inc.)
 */
public class KijimunaUI extends Plugin implements ConstUI {

	//	 static
	// -------------------------------------------------------------------

	private static KijimunaUI kijimunaUI;
	
	public static void reportException(Exception e) {
		kijimunaUI.messageManager.reportException(e);
	}

	public static String getResourceString(String key) {
		return kijimunaUI.messageManager.getResourceString(key);
	}
	
	public static String getResourceString(String key, Object[] args) {
		return kijimunaUI.messageManager.getResourceString(key, args);
	}

	public static Image getImage(String name) {
	    ImageDescriptor descriptor = getImageDescriptor(name);
	    return descriptor.createImage();
	}
	
	public static ImageDescriptor getImageDescriptor(String name) {
	    ImageDescriptor descriptor = kijimunaUI.registry.getDescriptor(name);
	    if(descriptor == null) {
	        URL url = kijimunaUI.getBundle().getEntry(PATH_IMAGES + name);
          	if(url != null) {
          	    descriptor = ImageDescriptor.createFromURL(url);
          	} else {
          	    descriptor = ImageDescriptor.getMissingImageDescriptor();
          	}
          	kijimunaUI.registry.put(name, descriptor);
	    }
	    return descriptor;
	}

	public static Image getSharedImage(String name) {
	    ImageDescriptor descriptor = getSharedImageDescriptor(name);
	    return descriptor.createImage();
	}
	
	public static ImageDescriptor getSharedImageDescriptor(String name) {
	    ImageDescriptor descriptor = kijimunaUI.images.getImageDescriptor(name);
	    if(descriptor == null) {
	        descriptor = ImageDescriptor.getMissingImageDescriptor();
	    }
	    return descriptor;
	}
	
	//	 instance
	// -------------------------------------------------------------------
	
	private MessageManager messageManager; 
	private ImageRegistry registry;
	private ISharedImages images;
	
	public KijimunaUI() {
		kijimunaUI = this;
		messageManager = new MessageManager(this, PATH_RESOURCES);
		registry = new ImageRegistry();
        images = new SharedImages();
	}
}
