/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.ui.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.seasar.kijimuna.core.dicon.model.ComponentElement;
import org.seasar.kijimuna.core.dicon.model.ContainerElement;
import org.seasar.kijimuna.core.parser.Element;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.util.StringUtils;
import org.seasar.kijimuna.ui.ConstUI;
import org.seasar.kijimuna.ui.KijimunaUI;
import org.seasar.kijimuna.ui.dicon.editor.DiconEditor;
import org.seasar.kijimuna.ui.dicon.provider.IExternalContainer;
import org.seasar.kijimuna.ui.dicon.provider.IHasJavaElement;
import org.seasar.kijimuna.ui.dicon.provider.IInjectedComponent;
import org.seasar.kijimuna.ui.dicon.provider.IInternalContainer;

public class WorkbenchUtils
implements ConstUI {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static IWorkbenchPage getWorkbenchPage() {
        IWorkbenchWindow window;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static IStorage getInputResource(IEditorPart part) {
        IEditorInput input = part.getEditorInput();
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        if (input instanceof IStorageEditorInput) {
            try {
                return ((IStorageEditorInput)input).getStorage();
            }
            catch (CoreException e) {
                KijimunaUI.reportException((Exception)((Object)e));
            }
        }
        return null;
    }

    public static DiconEditor openDiconEditor(IStorage storage) {
        IWorkbenchPage page;
        if (storage != null && (page = WorkbenchUtils.getWorkbenchPage()) != null) {
            try {
                if (storage instanceof IFile) {
                    FileEditorInput input = new FileEditorInput((IFile)storage);
                    return (DiconEditor)page.openEditor((IEditorInput)input, "org.seasar.kijimuna.ui.editor.dicon");
                }
                JarEntryEditorInput input = new JarEntryEditorInput(storage);
                return (DiconEditor)page.openEditor((IEditorInput)input, "org.seasar.kijimuna.ui.editor.dicon");
            }
            catch (CoreException e) {
                KijimunaUI.reportException((Exception)((Object)e));
            }
        }
        return null;
    }

    public static IEditorPart openJavaEditor(IJavaElement java) {
        try {
            IEditorPart part = JavaUI.openInEditor((IJavaElement)java);
            JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)java);
            return part;
        }
        catch (Exception e) {
            KijimunaUI.reportException(e);
            return null;
        }
    }

    public static IEditorPart showSource(IEditorPart part, Object obj) {
        Element element;
        IStorage file;
        if (obj instanceof IHasJavaElement) {
            IJavaElement java = ((IHasJavaElement)obj).getJavaElement();
            if (java != null) {
                return WorkbenchUtils.openJavaEditor(java);
            }
        } else if (obj instanceof IInjectedComponent) {
            IStorage file2;
            Element element2 = ((IInjectedComponent)obj).getInjectedElement();
            if (element2 != null && (file2 = element2.getStorage()) != null) {
                IStorage source = null;
                if (part != null) {
                    source = WorkbenchUtils.getInputResource(part);
                }
                int lineNumber = element2.getStartLine();
                if (!file2.equals(source)) {
                    DiconEditor editor = WorkbenchUtils.openDiconEditor(file2);
                    WorkbenchUtils.moveLine((IEditorPart)editor, lineNumber);
                    return editor;
                }
                WorkbenchUtils.moveLine(part, lineNumber);
            }
        } else if (obj instanceof IExternalContainer) {
            ContainerElement container = ((IExternalContainer)obj).getExternalContainer();
            if (container != null) {
                return WorkbenchUtils.openDiconEditor(container.getStorage());
            }
        } else if (obj instanceof IInternalContainer && (file = (element = ((IInternalContainer)obj).getElement()).getStorage()) != null) {
            IStorage source = null;
            if (part != null) {
                source = WorkbenchUtils.getInputResource(part);
            }
            if (!file.equals(source)) {
                int lineNumber = element.getStartLine();
                DiconEditor editor = WorkbenchUtils.openDiconEditor(file);
                WorkbenchUtils.moveLine((IEditorPart)editor, lineNumber);
                return editor;
            }
            if (element.getElementName().equals("component") && StringUtils.existValue((String)((ComponentElement)element).getComponentClassName())) {
                IRtti rtti;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.seasar.kijimuna.core.rtti.IRtti");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((rtti = (IRtti)element.getAdapter((Class)clazz)) != null) {
                    return WorkbenchUtils.openJavaEditor((IJavaElement)rtti.getType());
                }
            } else {
                IRtti rtti;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.seasar.kijimuna.core.rtti.IRtti");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((rtti = (IRtti)element.getAdapter((Class)clazz)) != null) {
                    IStorage injectedFile;
                    ComponentElement injected;
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("org.seasar.kijimuna.core.dicon.model.ComponentElement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((injected = (ComponentElement)rtti.getAdapter((Class)clazz2)) != null && (injectedFile = injected.getStorage()) != null) {
                        DiconEditor editor = !injectedFile.equals(source) ? WorkbenchUtils.openDiconEditor(injectedFile) : (DiconEditor)part;
                        WorkbenchUtils.moveLine((IEditorPart)editor, injected.getStartLine());
                        return editor;
                    }
                }
            }
        }
        return part;
    }

    public static void moveLine(IEditorPart part, int lineNumber) {
        if (part != null && lineNumber > 0) {
            try {
                IStorage file = WorkbenchUtils.getInputResource(part);
                if (file != null && file instanceof IFile) {
                    IMarker marker = ((IFile)file).createMarker("org.eclipse.core.resources.textmarker");
                    marker.setAttribute("lineNumber", lineNumber);
                    IDE.gotoMarker((IEditorPart)part, (IMarker)marker);
                    marker.delete();
                }
            }
            catch (CoreException e) {
                KijimunaUI.reportException((Exception)((Object)e));
            }
        }
    }

    public static IWorkbenchPart getWorkbenchPart() {
        IWorkbenchPage page = WorkbenchUtils.getWorkbenchPage();
        if (page != null) {
            return page.getActivePart();
        }
        return null;
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage page = WorkbenchUtils.getWorkbenchPage();
        if (page != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    public static IProject getCurrentProject(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Iterator it = ((IStructuredSelection)selection).iterator();
            while (it.hasNext()) {
                IResource resource;
                Object obj = it.next();
                if (!(obj instanceof IAdaptable)) continue;
                IAdaptable adaptable = (IAdaptable)obj;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (IResource)adaptable.getAdapter((Class)clazz)) == null) continue;
                return resource.getProject();
            }
        }
        return null;
    }

    public static Object getFirstSelectedElement(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    public static String[] getAllWorkbenchEncodings() {
        String eclipseEnc;
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < ConstUI.ECLIPSE_ENCODINGS.length) {
            list.add(ConstUI.ECLIPSE_ENCODINGS[i]);
            ++i;
        }
        String defaultEnc = System.getProperty("file.encoding", "UTF-8");
        if (!list.contains(defaultEnc)) {
            list.add(defaultEnc);
        }
        if (StringUtils.existValue((String)(eclipseEnc = WorkbenchUtils.getWorkbenchEncoding())) && !list.contains(eclipseEnc)) {
            list.add(eclipseEnc);
        }
        Collections.sort(list);
        return list.toArray(new String[list.size()]);
    }

    public static String getWorkbenchEncoding() {
        String enc = ResourcesPlugin.getPlugin().getPluginPreferences().getString("encoding");
        if (StringUtils.noneValue((String)enc)) {
            enc = System.getProperty("file.encoding", "UTF-8");
        }
        return enc;
    }
}

