/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.ui.dicon.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.seasar.kijimuna.core.dicon.DiconNature;
import org.seasar.kijimuna.core.parser.Element;
import org.seasar.kijimuna.core.project.IProjectRecordChangeListener;
import org.seasar.kijimuna.core.util.ProjectUtils;
import org.seasar.kijimuna.ui.ConstUI;
import org.seasar.kijimuna.ui.dicon.editor.DiconEditor;
import org.seasar.kijimuna.ui.dicon.provider.DiconContentProvider;
import org.seasar.kijimuna.ui.dicon.provider.DiconLabelProvider;
import org.seasar.kijimuna.ui.dicon.provider.IContentWalker;
import org.seasar.kijimuna.ui.dicon.provider.IInternalContainer;
import org.seasar.kijimuna.ui.dicon.provider.walker.OutlineContent;
import org.seasar.kijimuna.ui.util.WorkbenchUtils;

public class DiconOutlinePage
extends ContentOutlinePage
implements IProjectRecordChangeListener,
IDoubleClickListener,
ConstUI {
    private DiconEditor part;
    private TreeViewer viewer;
    static /* synthetic */ Class class$0;

    public DiconOutlinePage(DiconEditor part) {
        this.part = part;
    }

    private void setInput() {
        IProject project;
        IStorage storage = WorkbenchUtils.getInputResource((IEditorPart)this.part);
        if (storage != null && (project = storage instanceof IFile ? ((IFile)storage).getProject() : ProjectUtils.getProjectFromDiconStorage((IStorage)storage)) != null) {
            this.viewer.setInput((Object)new OutlineContent(project, storage));
            return;
        }
        this.viewer.setInput(null);
    }

    private DiconNature getNature() {
        IStorage storage = WorkbenchUtils.getInputResource((IEditorPart)this.part);
        if (storage != null && storage instanceof IFile) {
            IProject project = ((IFile)storage).getProject();
            return DiconNature.getInstance((IProject)project);
        }
        return null;
    }

    private IContentWalker findLine(IContentWalker walker, int lineNumber) {
        Element element;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.kijimuna.core.parser.Element");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((element = (Element)walker.getAdapter(clazz)) != null) {
            int startLine = element.getStartLine();
            int endLine = element.getEndLine();
            if (startLine <= lineNumber && lineNumber <= endLine) {
                return walker;
            }
        }
        Object[] obj = walker.getChildren();
        int i = 0;
        while (i < obj.length) {
            if (obj[i] instanceof IContentWalker) {
                return this.findLine((IContentWalker)obj[i], lineNumber);
            }
            ++i;
        }
        return null;
    }

    public void syncEditor(int lineNumber) {
        IContentWalker walker;
        IContentWalker selected;
        OutlineContent content = (OutlineContent)this.viewer.getInput();
        Object[] obj = content.getTopLevelItems();
        if (obj[1] instanceof IContentWalker && (selected = this.findLine(walker = (IContentWalker)obj[1], lineNumber)) != null) {
            StructuredSelection selection = new StructuredSelection((Object)selected);
            this.viewer.setSelection((ISelection)selection, true);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.viewer = this.getTreeViewer();
        this.viewer.setContentProvider((IContentProvider)new DiconContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DiconLabelProvider());
        this.viewer.setAutoExpandLevel(5);
        this.viewer.addDoubleClickListener((IDoubleClickListener)this);
        this.setInput();
        DiconNature nature = this.getNature();
        if (nature != null) {
            nature.getModel().addRecordChangeListener((IProjectRecordChangeListener)this);
        }
    }

    public void dispose() {
        DiconNature nature = this.getNature();
        if (nature != null) {
            nature.getModel().removeRecordChangeListener((IProjectRecordChangeListener)this);
        }
        super.dispose();
    }

    public void finishChanged() {
        Tree control = this.viewer.getTree();
        Display display = control.getDisplay();
        display.syncExec(new Runnable((Control)control){
            private final /* synthetic */ Control val$control;
            {
                this.val$control = control;
            }

            public void run() {
                if (this.val$control.isDisposed()) {
                    return;
                }
                DiconOutlinePage.this.setInput();
            }
        });
    }

    public void doubleClick(DoubleClickEvent event) {
        Object obj = WorkbenchUtils.getFirstSelectedElement(event.getSelection());
        WorkbenchUtils.showSource((IEditorPart)this.part, obj);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        Object obj = WorkbenchUtils.getFirstSelectedElement(event.getSelection());
        if (obj instanceof IInternalContainer) {
            Element element = ((IInternalContainer)obj).getElement();
            WorkbenchUtils.moveLine((IEditorPart)this.part, element.getStartLine());
        }
    }
}

