/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.ui.dicon.editor;

import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.seasar.kijimuna.ui.ConstUI;
import org.seasar.kijimuna.ui.KijimunaUI;
import org.seasar.kijimuna.ui.dicon.editor.DiconOutlinePage;
import org.seasar.kijimuna.ui.dicon.editor.EditorPartItem;

public class DiconEditor
extends MultiPageEditorPart
implements ConstUI {
    private DiconOutlinePage outline;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private int addEditorPage(IEditorPart part, String title) {
        int ret = 0;
        try {
            ret = this.addPage(part, this.getEditorInput());
            this.setPageText(ret, title);
        }
        catch (PartInitException e) {
            KijimunaUI.reportException((Exception)((Object)e));
        }
        return ret;
    }

    public DiconOutlinePage getOutlinePage() {
        if (this.outline == null) {
            this.outline = new DiconOutlinePage(this);
        }
        return this.outline;
    }

    protected void createPages() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.seasar.kijimuna.ui.diconeditorpart");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            TreeSet<EditorPartItem> set = new TreeSet<EditorPartItem>();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement conf = extensions[i].getConfigurationElements()[0];
                try {
                    Object obj = conf.createExecutableExtension("class");
                    if (obj instanceof IEditorPart) {
                        IEditorPart editor = (IEditorPart)obj;
                        String title = conf.getAttribute("name");
                        int index = Integer.parseInt(conf.getAttribute("index"));
                        set.add(new EditorPartItem(editor, title, index));
                    }
                }
                catch (Exception e) {
                    KijimunaUI.reportException(e);
                }
                ++i;
            }
            Iterator it = set.iterator();
            while (it.hasNext()) {
                EditorPartItem item = (EditorPartItem)it.next();
                this.addEditorPage(item.getEditorPart(), item.getTitle());
            }
        }
        this.setPartName(this.getEditorInput().getName());
        this.setTitleToolTip(this.getEditorInput().getToolTipText());
    }

    public void doSave(IProgressMonitor monitor) {
        int i = 0;
        while (i < this.getPageCount()) {
            IEditorPart editor = this.getEditor(i);
            if (editor.isSaveAsAllowed() && editor.isDirty()) {
                editor.doSave(monitor);
                break;
            }
            ++i;
        }
    }

    public void doSaveAs() {
        int i = 0;
        while (i < this.getPageCount()) {
            IEditorPart editor = this.getEditor(i);
            if (editor.isSaveAsAllowed()) {
                editor.doSaveAs();
                IEditorInput input = editor.getEditorInput();
                this.setInput(input);
                this.setPartName(input.getName());
                this.setTitleToolTip(this.getEditorInput().getToolTipText());
                return;
            }
            ++i;
        }
    }

    public boolean isSaveAsAllowed() {
        int i = 0;
        while (i < this.getPageCount()) {
            IEditorPart editor = this.getEditor(i);
            if (editor.isSaveAsAllowed()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this.getOutlinePage();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz2)) {
            int i = 0;
            while (i < this.getPageCount()) {
                Object obj;
                IEditorPart editor = this.getEditor(i);
                if (editor instanceof IGotoMarker) {
                    return editor;
                }
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((obj = editor.getAdapter((Class)clazz3)) != null) {
                    return obj;
                }
                ++i;
            }
            return null;
        }
        return super.getAdapter(adapter);
    }
}

