/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.ui;

import java.net.URL;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.internal.ui.SharedImages;
import org.eclipse.jdt.ui.ISharedImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.seasar.kijimuna.core.MessageManager;
import org.seasar.kijimuna.ui.ConstUI;

public class KijimunaUI
extends Plugin
implements ConstUI {
    private static KijimunaUI kijimunaUI;
    private MessageManager messageManager;
    private ImageRegistry registry;
    private ISharedImages images;

    public static void reportException(Exception e) {
        KijimunaUI.kijimunaUI.messageManager.reportException(e);
    }

    public static String getResourceString(String key) {
        return KijimunaUI.kijimunaUI.messageManager.getResourceString(key);
    }

    public static String getResourceString(String key, Object[] args) {
        return KijimunaUI.kijimunaUI.messageManager.getResourceString(key, args);
    }

    public static Image getImage(String name) {
        ImageDescriptor descriptor = KijimunaUI.getImageDescriptor(name);
        return descriptor.createImage();
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        ImageDescriptor descriptor = KijimunaUI.kijimunaUI.registry.getDescriptor(name);
        if (descriptor == null) {
            URL url = kijimunaUI.getBundle().getEntry("/images/" + name);
            descriptor = url != null ? ImageDescriptor.createFromURL((URL)url) : ImageDescriptor.getMissingImageDescriptor();
            KijimunaUI.kijimunaUI.registry.put(name, descriptor);
        }
        return descriptor;
    }

    public static Image getSharedImage(String name) {
        ImageDescriptor descriptor = KijimunaUI.getSharedImageDescriptor(name);
        return descriptor.createImage();
    }

    public static ImageDescriptor getSharedImageDescriptor(String name) {
        ImageDescriptor descriptor = KijimunaUI.kijimunaUI.images.getImageDescriptor(name);
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        return descriptor;
    }

    public KijimunaUI() {
        kijimunaUI = this;
        this.messageManager = new MessageManager((Plugin)this, "org.seasar.kijimuna.ui.resources");
        this.registry = new ImageRegistry();
        this.images = new SharedImages();
    }
}

