/*
 * Decompiled with CFR 0.152.
 */
package org.ognl.util;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ognl.el.Operations;
import org.ognl.el.extensions.DefaultOperations;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class RuntimeUtils {
    private static final String NULL_STRING = "null";
    private static final String SINGLE_LEVEL_DEPTH_STRING = "   ";
    private static final Map DEPTH_STRINGS = new HashMap();
    private static DecimalFormat POINTER_FORMAT = new DecimalFormat("'0'x00000000");
    public static final String EMPTY_STRING = "";
    public static final String NULL_OBJECT_STRING = "<null>";
    public static final int LEAFMOST_FIRST = 0;
    public static final int ROOTMOST_FIRST = 1;
    public static final Object NotFound = new Object();
    public static final Object[] NoArguments = new Object[0];
    public static final List NotFoundList = new ArrayList();
    public static final Map NotFoundMap = new HashMap();
    public static final Operations DEFAULT_OPERATIONS = new DefaultOperations();
    private static Map PRIMITIVE_TYPES = new HashMap(101);
    private static IdentityHashMap PRIMITIVE_WRAPPER_CLASSES = new IdentityHashMap();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public static String getBaseName(Object o) {
        return o == null ? null : RuntimeUtils.getClassBaseName(o instanceof Class ? (Class<?>)o : o.getClass());
    }

    public static String getPackageName(Object o) {
        return o == null ? null : RuntimeUtils.getClassPackageName(o instanceof Class ? (Class<?>)o : o.getClass());
    }

    public static String getClassBaseName(Class c) {
        String result = null;
        if (c != null) {
            String s = c.getName();
            result = s.substring(s.lastIndexOf(46) + 1);
        }
        return result;
    }

    public static String getClassName(Object o, boolean fullyQualified) {
        return o == null ? null : RuntimeUtils.getClassName(o instanceof Class ? (Class<?>)o : o.getClass(), fullyQualified);
    }

    public static String getClassName(Class c, boolean fullyQualified) {
        return c == null ? null : (fullyQualified ? c.getName() : RuntimeUtils.getClassBaseName(c));
    }

    public static String getClassPackageName(Class c) {
        String result = null;
        if (c != null) {
            String s = c.getName();
            int i = s.lastIndexOf(46);
            result = i < 0 ? null : s.substring(0, i);
        }
        return result;
    }

    public static String getClassDescriptor(Class c, boolean fullyQualified) {
        return c == null ? NULL_STRING : RuntimeUtils.getClassName(c, fullyQualified);
    }

    public static String getClassDescriptor(Class c) {
        return RuntimeUtils.getClassDescriptor(c, true);
    }

    public static String getClassDescriptor(Object object, boolean fullyQualified) {
        return RuntimeUtils.getClassDescriptor(object == null ? null : object.getClass(), fullyQualified);
    }

    public static String getClassDescriptor(Object object) {
        return RuntimeUtils.getClassDescriptor(object, true);
    }

    public static String getPointerString(int ptr) {
        return POINTER_FORMAT.format(ptr);
    }

    public static String getPointerString(Object o) {
        int n = 0;
        if (o != null) {
            n = System.identityHashCode(o);
        }
        return RuntimeUtils.getPointerString(n);
    }

    public static String getUniqueDescriptor(Object object, boolean fullyQualified) {
        StringBuffer result = new StringBuffer();
        if (object != null) {
            if (object instanceof Proxy) {
                Class<?> interfaceClass = object.getClass().getInterfaces()[0];
                result.append(RuntimeUtils.getClassName(interfaceClass, fullyQualified));
                result.append('^');
                object = Proxy.getInvocationHandler(object);
            }
            result.append(RuntimeUtils.getClassName(object, fullyQualified));
            result.append('@');
            result.append(RuntimeUtils.getPointerString(object));
        } else {
            result.append(NULL_OBJECT_STRING);
        }
        return new String(result);
    }

    public static String getUniqueDescriptor(Object object) {
        return RuntimeUtils.getUniqueDescriptor(object, false);
    }

    public static Class getObjectClass(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Class) {
            return (Class)object;
        }
        return object.getClass();
    }

    public static String getSingleLevelDepthString() {
        return SINGLE_LEVEL_DEPTH_STRING;
    }

    public static String getDepthString(int depth) {
        String s;
        if (depth == 0) {
            s = EMPTY_STRING;
        } else {
            Integer d = new Integer(depth);
            s = (String)DEPTH_STRINGS.get(d);
            if (s == null) {
                s = RuntimeUtils.getDepthString(depth - 1) + RuntimeUtils.getSingleLevelDepthString();
                DEPTH_STRINGS.put(d, s);
            }
        }
        return s;
    }

    public static Class findClass(String className, List packages) {
        Class result = RuntimeUtils.findClass(className);
        if (result == null) {
            Iterator it = packages.iterator();
            while (result == null && it.hasNext()) {
                String pkg = (String)it.next();
                String cs = pkg != null ? pkg + '.' + className : className;
                result = RuntimeUtils.findClass(cs);
            }
        }
        return result;
    }

    public static Class findClass(String className) {
        Class<?> result = null;
        try {
            result = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public static List getSuperclasses(Class startClass, Class endClass, int ordering) {
        ArrayList result = new ArrayList();
        if (endClass != null && startClass != null) {
            if (endClass.isAssignableFrom(startClass)) {
                Class c = startClass;
                while (c != endClass.getSuperclass()) {
                    if (ordering == 0) {
                        result.add(c);
                    } else if (ordering == 1) {
                        result.add(0, c);
                    } else {
                        throw new IllegalArgumentException("ordering " + ordering + " unknown");
                    }
                    c = c.getSuperclass();
                }
            } else {
                throw new IllegalArgumentException("end class " + endClass.getName() + " must be instance of " + startClass.getName());
            }
        }
        return result;
    }

    public static Class getFirstSubclass(Object object, Class baseClass) {
        Class<?> result = null;
        if (object != null && baseClass != null) {
            if (!baseClass.isAssignableFrom(object.getClass())) {
                throw new IllegalArgumentException(baseClass.getName() + " is not a superclass of " + object.getClass().getName());
            }
            result = object.getClass();
            while (result != null && result.getSuperclass() != baseClass) {
                result = result.getSuperclass();
            }
        }
        return result;
    }

    public static String getTypeString(Class c) {
        StringBuffer sb = new StringBuffer();
        while (c.isArray()) {
            sb.append("[]");
            c = c.getComponentType();
        }
        sb.insert(0, c.getName());
        return new String(sb);
    }

    public static String getModifierString(int modifiers) {
        return modifiers == 0 ? EMPTY_STRING : Modifier.toString(modifiers);
    }

    public static Class getPrimitiveClass(String name) {
        return (Class)PRIMITIVE_TYPES.get(name);
    }

    public static Class getPrimitiveClass(Class wrapperClass) {
        return (Class)PRIMITIVE_WRAPPER_CLASSES.get(wrapperClass);
    }

    public static Class getPrimitiveWrapperClass(Class primitiveClass) {
        return (Class)PRIMITIVE_WRAPPER_CLASSES.get(primitiveClass);
    }

    public static boolean isTypeCompatible(Class withClass, Object object) {
        boolean result = true;
        if (object != null) {
            Class<?> objectClass = object.getClass();
            if (withClass.isPrimitive()) {
                if (RuntimeUtils.getPrimitiveClass(objectClass) != withClass) {
                    result = false;
                }
            } else if (!withClass.isAssignableFrom(objectClass)) {
                result = false;
            }
        }
        return result;
    }

    public static boolean areTypesCompatible(Class[] classes, Object[] objects) {
        boolean result = true;
        if (objects.length != classes.length) {
            result = false;
        } else {
            int index = 0;
            int count = objects.length;
            while (result && index < count) {
                result = RuntimeUtils.isTypeCompatible(classes[index], objects[index]);
                ++index;
            }
        }
        return result;
    }

    public static final boolean isMoreSpecific(Class[] classes1, Class[] classes2) {
        int index = 0;
        int count = classes1.length;
        while (index < count) {
            Class c1 = classes1[index];
            Class c2 = classes2[index];
            if (c1 != c2) {
                if (c1.isPrimitive()) {
                    return true;
                }
                if (c1.isAssignableFrom(c2)) {
                    return false;
                }
                if (c2.isAssignableFrom(c1)) {
                    return true;
                }
            }
            ++index;
        }
        return false;
    }

    public static Method getMethod(Class c, String methodName, Class[] arguments) {
        Method result = null;
        if (arguments.length == 1) {
            Class[] aca = new Class[]{arguments[0]};
            while (result == null && aca[0] != null) {
                try {
                    result = c.getMethod(methodName, aca);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                aca[0] = aca[0].getSuperclass();
            }
        } else {
            try {
                result = c.getMethod(methodName, arguments);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean isValidInteger(String s) {
        boolean valid = false;
        String ts = s.trim();
        int i = 0;
        int max = ts.length();
        while (i < max) {
            valid = Character.isDigit(ts.charAt(i));
            if (!valid) break;
            ++i;
        }
        return valid;
    }

    public static boolean isNullString(String value) {
        boolean bl = false;
        if (value == null || value.length() == 0 || value.trim().length() == 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqual(Object object1, Object object2) {
        return RuntimeUtils.isEqual(object1, object2, null);
    }

    public static boolean isEqual(Object object1, Object object2, Operations operations) {
        boolean result = false;
        if (object1 == object2 || object1 != null && object2 != null && object1.equals(object2)) {
            result = true;
        } else if (object1 != null && object1.getClass().isArray()) {
            if (object2 != null && object2.getClass().isArray() && object2.getClass() == object1.getClass()) {
                boolean bl = false;
                if (Array.getLength(object1) == Array.getLength(object2)) {
                    bl = true;
                }
                if (result = bl) {
                    int i = 0;
                    int icount = Array.getLength(object1);
                    while (result && i < icount) {
                        result = RuntimeUtils.isEqual(Array.get(object1, i), Array.get(object2, i), operations);
                        ++i;
                    }
                }
            }
        } else if (object1 != null && object2 != null) {
            if (operations == null) {
                operations = DEFAULT_OPERATIONS;
            }
            boolean bl = false;
            if (operations.compareWithConversion(object1, object2) == 0) {
                bl = true;
            }
            result = bl;
        }
        return result;
    }

    public static Throwable getRootCause(Throwable ex) {
        Throwable result = ex;
        while (true) {
            Throwable tex = null;
            tex = result instanceof InvocationTargetException ? ((InvocationTargetException)result).getTargetException() : (result instanceof ExceptionInInitializerError ? ((ExceptionInInitializerError)result).getException() : result.getCause());
            if (tex == null) break;
            result = tex;
        }
        return result;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        PRIMITIVE_TYPES.put("boolean", Boolean.TYPE);
        PRIMITIVE_TYPES.put("byte", Byte.TYPE);
        PRIMITIVE_TYPES.put("char", Character.TYPE);
        PRIMITIVE_TYPES.put("short", Short.TYPE);
        PRIMITIVE_TYPES.put("int", Integer.TYPE);
        PRIMITIVE_TYPES.put("long", Long.TYPE);
        PRIMITIVE_TYPES.put("float", Float.TYPE);
        PRIMITIVE_TYPES.put("double", Double.TYPE);
        Class clazz = class$java$lang$Boolean;
        if (clazz == null) {
            clazz = class$java$lang$Boolean = RuntimeUtils.class("[Ljava.lang.Boolean;", false);
        }
        PRIMITIVE_WRAPPER_CLASSES.put(Boolean.TYPE, clazz);
        Class clazz2 = class$java$lang$Boolean;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Boolean = RuntimeUtils.class("[Ljava.lang.Boolean;", false);
        }
        PRIMITIVE_WRAPPER_CLASSES.put(clazz2, Boolean.TYPE);
        Class clazz3 = class$java$lang$Byte;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Byte = RuntimeUtils.class("[Ljava.lang.Byte;", false);
        }
        PRIMITIVE_WRAPPER_CLASSES.put(Byte.TYPE, clazz3);
        Class clazz4 = class$java$lang$Byte;
        if (clazz4 == null) {
            clazz4 = class$java$lang$Byte = RuntimeUtils.class("[Ljava.lang.Byte;", false);
        }
        PRIMITIVE_WRAPPER_CLASSES.put(clazz4, Byte.TYPE);
        Class clazz5 = class$java$lang$Character;
        if (clazz5 == null) {
            clazz5 = class$java$lang$Character = RuntimeUtils.class("[Ljava.lang.Character;", false);
        }
        PRIMITIVE_WRAPPER_CLASSES.put(Character.TYPE, clazz5);
        Class clazz6 = class$java$lang$Character;
        if (clazz6 == null) {
            clazz6 = class$java$lang$Character = RuntimeUtils.class("[Ljava.lang.Character;", false);
        }
        PRIMITIVE_WRAPPER_CLASSES.put(clazz6, Character.TYPE);
        Class clazz7 = class$java$lang$Short;
        if (clazz7 == null) {
            clazz7 = class$java$lang$Short = RuntimeUtils.class("[Ljava.lang.Short;", false);
        }
        PRIMITIVE_WRAPPER_CLASSES.put(Short.TYPE, clazz7);
        Class clazz8 = class$java$lang$Short;
        if (clazz8 == null) {
            clazz8 = class$java$lang$Short = RuntimeUtils.class("[Ljava.lang.Short;", false);
        }
        PRIMITIVE_WRAPPER_CLASSES.put(clazz8, Short.TYPE);
        Class clazz9 = class$java$lang$Integer;
        if (clazz9 == null) {
            clazz9 = class$java$lang$Integer = RuntimeUtils.class("[Ljava.lang.Integer;", false);
        }
        PRIMITIVE_WRAPPER_CLASSES.put(Integer.TYPE, clazz9);
        Class clazz10 = class$java$lang$Integer;
        if (clazz10 == null) {
            clazz10 = class$java$lang$Integer = RuntimeUtils.class("[Ljava.lang.Integer;", false);
        }
        PRIMITIVE_WRAPPER_CLASSES.put(clazz10, Integer.TYPE);
        Class clazz11 = class$java$lang$Long;
        if (clazz11 == null) {
            clazz11 = class$java$lang$Long = RuntimeUtils.class("[Ljava.lang.Long;", false);
        }
        PRIMITIVE_WRAPPER_CLASSES.put(Long.TYPE, clazz11);
        Class clazz12 = class$java$lang$Long;
        if (clazz12 == null) {
            clazz12 = class$java$lang$Long = RuntimeUtils.class("[Ljava.lang.Long;", false);
        }
        PRIMITIVE_WRAPPER_CLASSES.put(clazz12, Long.TYPE);
        Class clazz13 = class$java$lang$Float;
        if (clazz13 == null) {
            clazz13 = class$java$lang$Float = RuntimeUtils.class("[Ljava.lang.Float;", false);
        }
        PRIMITIVE_WRAPPER_CLASSES.put(Float.TYPE, clazz13);
        Class clazz14 = class$java$lang$Float;
        if (clazz14 == null) {
            clazz14 = class$java$lang$Float = RuntimeUtils.class("[Ljava.lang.Float;", false);
        }
        PRIMITIVE_WRAPPER_CLASSES.put(clazz14, Float.TYPE);
        Class clazz15 = class$java$lang$Double;
        if (clazz15 == null) {
            clazz15 = class$java$lang$Double = RuntimeUtils.class("[Ljava.lang.Double;", false);
        }
        PRIMITIVE_WRAPPER_CLASSES.put(Double.TYPE, clazz15);
        Class clazz16 = class$java$lang$Double;
        if (clazz16 == null) {
            clazz16 = class$java$lang$Double = RuntimeUtils.class("[Ljava.lang.Double;", false);
        }
        PRIMITIVE_WRAPPER_CLASSES.put(clazz16, Double.TYPE);
    }
}

