/*
 * Decompiled with CFR 0.152.
 */
package org.ognl.util;

import java.util.Arrays;
import org.ognl.util.Pool;

public class ObjectArrayPool
extends Pool {
    private int arraySize;

    public int getArraySize() {
        return this.arraySize;
    }

    public synchronized Object[] create() {
        Object[] result = (Object[])this.recoverObject();
        if (result == null) {
            result = new Object[this.arraySize];
            this.objectCreated(result);
        }
        return result;
    }

    protected void objectRecycleCheck(Object value) throws IllegalArgumentException {
        super.objectRecycleCheck(value);
        if (value instanceof Object[]) {
            int actualSize = ((Object[])value).length;
            if (actualSize != this.getArraySize()) {
                throw new IllegalArgumentException("recycled array size " + actualSize + " inappropriate for pool array size " + this.getArraySize());
            }
        } else {
            throw new IllegalArgumentException("recycled object not an Object array");
        }
    }

    protected void objectRecycled(Object value) {
        Arrays.fill((Object[])value, null);
        super.objectRecycled(value);
    }

    public ObjectArrayPool(int arraySize) {
        this(arraySize, 0);
    }

    public ObjectArrayPool(int arraySize, int initialPoolSize) {
        super(initialPoolSize);
        this.arraySize = arraySize;
        int i = 0;
        while (i < initialPoolSize) {
            this.getObjects().add(new Object[arraySize]);
            ++i;
        }
    }
}

