/*
 * Decompiled with CFR 0.152.
 */
package org.ognl.el.parser;

import java.io.Serializable;
import org.ognl.el.Environment;
import org.ognl.el.ExecutionEnvironment;
import org.ognl.el.Expression;
import org.ognl.el.ExpressionVisitor;
import org.ognl.el.InappropriateExpressionException;
import org.ognl.el.OgnlException;
import org.ognl.el.TypeConversionException;
import org.ognl.el.TypeConverter;
import org.ognl.el.parser.Node;
import org.ognl.el.parser.ParserTreeConstants;
import org.ognl.util.RuntimeUtils;

public abstract class SimpleNode
implements Node,
Serializable {
    private boolean constantValueCalculated;
    private boolean hasConstantValue;
    private Object constantValue;
    protected int id;
    protected Node parent;
    protected Node[] children;

    protected void flattenTree() {
        boolean shouldFlatten = false;
        int newSize = 0;
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i].getClass() == this.getClass()) {
                shouldFlatten = true;
                newSize += this.children[i].jjtGetNumChildren();
            } else {
                ++newSize;
            }
            ++i;
        }
        if (shouldFlatten) {
            Node[] newChildren = new Node[newSize];
            int j = 0;
            int i2 = 0;
            while (i2 < this.children.length) {
                Node c = this.children[i2];
                if (c.getClass() == this.getClass()) {
                    int k = 0;
                    while (k < c.jjtGetNumChildren()) {
                        newChildren[j++] = c.jjtGetChild(k);
                        ++k;
                    }
                } else {
                    newChildren[j++] = c;
                }
                ++i2;
            }
            if (j != newSize) {
                throw new Error("Assertion error: " + j + " != " + newSize);
            }
            this.children = newChildren;
        }
    }

    protected Object convertValue(ExecutionEnvironment environment, Object target, Class toType, Object value) throws OgnlException {
        Object result;
        if (!(toType == null || value != null && RuntimeUtils.isTypeCompatible(toType, value))) {
            TypeConverter typeConverter = environment.getTypeConverter(RuntimeUtils.getObjectClass(target));
            result = typeConverter.convertValue(environment, toType, value);
            if (result == TypeConverter.NoConversionPossible) {
                throw new TypeConversionException(this.toString(), toType, value);
            }
        } else {
            result = value;
        }
        return result;
    }

    protected Object getValueBody(ExecutionEnvironment environment, Object source) throws OgnlException {
        throw new OgnlException(this.toString() + " must provide implementation of getValueBody()");
    }

    protected Object getValueBody(ExecutionEnvironment environment, Object source, Class asType) throws OgnlException {
        return this.convertValue(environment, source, asType, this.getValueBody(environment, source));
    }

    protected void setValueBody(ExecutionEnvironment environment, Object target, Object value) throws OgnlException {
        throw new InappropriateExpressionException(this);
    }

    protected void setValueBody(ExecutionEnvironment environment, Object target, Class asType, Object value) throws OgnlException {
        this.setValueBody(environment, target, this.convertValue(environment, target, asType, value));
    }

    public String toString() {
        return this.getTypeName();
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public int jjtGetNumChildren() {
        int n = 0;
        if (this.children != null) {
            n = this.children.length;
        }
        return n;
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public void jjtOpen() {
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    public void jjtClose() {
    }

    public int getTypeId() {
        return this.id;
    }

    public String getTypeName() {
        return ParserTreeConstants.jjtNodeName[this.id];
    }

    public Expression getParent() {
        return this.jjtGetParent();
    }

    public int getChildCount() {
        return this.jjtGetNumChildren();
    }

    public Expression getChild(int index) {
        return this.jjtGetChild(index);
    }

    public void visitInOrder(ExpressionVisitor visitor) {
        if (visitor.willVisitExpression(this)) {
            if (this.children != null) {
                int i = 0;
                while (i < this.children.length) {
                    Node n = this.children[i];
                    if (n != null) {
                        n.visitInOrder(visitor);
                    }
                    ++i;
                }
            }
            visitor.didVisitExpression(this);
        }
    }

    public boolean isConstant(Environment environment) throws OgnlException {
        return false;
    }

    public boolean isSimpleProperty(Environment environment) throws OgnlException {
        return false;
    }

    public boolean isSimpleNavigationChain(Environment environment) throws OgnlException {
        return this.isSimpleProperty(environment);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object getValue(ExecutionEnvironment environment, Object source, Class asType) throws OgnlException {
        Object result = null;
        try {
            try {
                environment.startEvaluation(this, "get", source);
                if (!this.constantValueCalculated) {
                    this.constantValueCalculated = true;
                    this.hasConstantValue = this.isConstant(environment);
                    if (this.hasConstantValue) {
                        this.constantValue = this.getValueBody(environment, source, null);
                    }
                }
                result = this.hasConstantValue ? this.convertValue(environment, source, asType, this.constantValue) : this.getValueBody(environment, source, asType);
            }
            catch (OgnlException ex) {
                result = ex;
                throw ex;
            }
            catch (RuntimeException ex) {
                result = ex;
                throw ex;
            }
            catch (Error ex) {
                result = ex;
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            environment.endEvaluation(this, "get", source, result);
            throw throwable;
        }
        {
            Object var6_10 = null;
            environment.endEvaluation(this, "get", source, result);
            return result;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setValue(ExecutionEnvironment environment, Object target, Class asType, Object value) throws OgnlException {
        Throwable result = null;
        try {
            try {
                environment.startEvaluation(this, "set", target);
                this.setValueBody(environment, target, asType, value);
            }
            catch (OgnlException ex) {
                result = ex;
                throw ex;
            }
            catch (RuntimeException ex) {
                result = ex;
                throw ex;
            }
            catch (Error ex) {
                result = ex;
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            environment.endEvaluation(this, "get", target, result);
            throw throwable;
        }
        {
            Object var7_11 = null;
            environment.endEvaluation(this, "get", target, result);
            return;
        }
    }

    public SimpleNode(int i) {
        this.id = i;
    }
}

