/*
 * Decompiled with CFR 0.152.
 */
package org.ognl.el.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.ognl.el.Environment;
import org.ognl.el.ExecutionEnvironment;
import org.ognl.el.OgnlException;
import org.ognl.el.parser.Node;
import org.ognl.el.parser.SimpleNode;

public class ASTConst
extends SimpleNode {
    private Object value;

    public String getEscapedChar(char ch) {
        String result;
        switch (ch) {
            case '\b': {
                result = "\b";
                break;
            }
            case '\t': {
                result = "\\t";
                break;
            }
            case '\n': {
                result = "\\n";
                break;
            }
            case '\f': {
                result = "\\f";
                break;
            }
            case '\r': {
                result = "\\r";
                break;
            }
            case '\"': {
                result = "\\\"";
                break;
            }
            case '\'': {
                result = "\\'";
                break;
            }
            case '\\': {
                result = "\\\\";
                break;
            }
            default: {
                if (Character.isISOControl(ch) || ch > '\u00ff') {
                    String hc = Integer.toString(ch, 16);
                    int hcl = hc.length();
                    result = "\\u";
                    if (hcl < 4) {
                        result = hcl == 3 ? result + '0' : (hcl == 2 ? result + "00" : result + "000");
                    }
                    result = result + hc;
                    break;
                }
                result = new String("" + ch);
                break;
            }
        }
        return result;
    }

    public String getEscapedString(String value) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        int icount = value.length();
        while (i < icount) {
            result.append(this.getEscapedChar(value.charAt(i)));
            ++i;
        }
        return new String(result);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    protected Object getValueBody(ExecutionEnvironment environment, Object source) throws OgnlException {
        return this.value;
    }

    public boolean isConstant(Environment environment) throws OgnlException {
        return true;
    }

    public String toString() {
        String result;
        Object v = this.getValue();
        if (v == null) {
            result = "null";
        } else if (v instanceof String) {
            result = "\"" + this.getEscapedString(v.toString()) + '\"';
        } else if (v instanceof Character) {
            result = "'" + this.getEscapedChar(((Character)v).charValue()) + '\'';
        } else {
            result = v.toString();
            if (v instanceof Long) {
                result = result + 'L';
            } else if (v instanceof BigDecimal) {
                result = result + 'B';
            } else if (v instanceof BigInteger) {
                result = result + 'H';
            } else if (v instanceof Node) {
                result = ":[ " + result + " ]";
            }
        }
        return result;
    }

    public ASTConst(int id) {
        super(id);
    }
}

