/*
 * Decompiled with CFR 0.152.
 */
package org.ognl.el.extensions;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import org.ognl.el.ExecutionEnvironment;
import org.ognl.el.MemberAccess;

public class DefaultMemberAccess
implements MemberAccess {
    private boolean allowPrivateAccess;
    private boolean allowProtectedAccess;
    private boolean allowPackageProtectedAccess;

    public void setAllowPackageProtectedAccess(boolean value) {
        this.allowPackageProtectedAccess = value;
    }

    public boolean getAllowPackageProtectedAccess() {
        return this.allowPackageProtectedAccess;
    }

    public void setAllowPrivateAccess(boolean value) {
        this.allowPrivateAccess = value;
    }

    public boolean getAllowPrivateAccess() {
        return this.allowPrivateAccess;
    }

    public void setAllowProtectedAccess(boolean value) {
        this.allowProtectedAccess = value;
    }

    public boolean getAllowProtectedAccess() {
        return this.allowProtectedAccess;
    }

    public boolean isAccessible(ExecutionEnvironment environment, Object target, Member member) {
        int modifiers = member.getModifiers();
        boolean result = Modifier.isPublic(modifiers);
        if (!result) {
            result = Modifier.isPrivate(modifiers) ? this.getAllowPrivateAccess() : (Modifier.isProtected(modifiers) ? this.getAllowProtectedAccess() : this.getAllowPackageProtectedAccess());
        }
        return result;
    }

    public Object makeAccessible(ExecutionEnvironment environment, Object target, Member member) {
        AccessibleObject accessible;
        Boolean result = null;
        if (this.isAccessible(environment, target, member) && !(accessible = (AccessibleObject)((Object)member)).isAccessible()) {
            result = Boolean.FALSE;
            accessible.setAccessible(true);
        }
        return result;
    }

    public void restoreAccessible(ExecutionEnvironment environment, Object target, Member member, Object state) {
        if (state != null) {
            ((AccessibleObject)((Object)member)).setAccessible((Boolean)state);
        }
    }

    public DefaultMemberAccess(boolean allowAllAccess) {
        this(allowAllAccess, allowAllAccess, allowAllAccess);
    }

    public DefaultMemberAccess(boolean allowPrivateAccess, boolean allowProtectedAccess, boolean allowPackageProtectedAccess) {
        this.allowPrivateAccess = allowPrivateAccess;
        this.allowProtectedAccess = allowProtectedAccess;
        this.allowPackageProtectedAccess = allowPackageProtectedAccess;
    }
}

