/*
 * Decompiled with CFR 0.152.
 */
package org.ognl.el.extensions;

import java.lang.reflect.Array;
import org.ognl.el.DynamicSubscript;
import org.ognl.el.ExecutionEnvironment;
import org.ognl.el.NoSuchPropertyException;
import org.ognl.el.OgnlException;
import org.ognl.el.TypeConverter;
import org.ognl.el.extensions.AbstractPropertyAccessor;

public class ArrayPropertyAccessor
extends AbstractPropertyAccessor {
    public Object getPropertyValue(ExecutionEnvironment environment, Object target, Object property) throws OgnlException {
        Object result = property instanceof String && property.equals("length") ? new Integer(Array.getLength(target)) : super.getPropertyValue(environment, target, property);
        return result;
    }

    public Object getIndexedPropertyValue(ExecutionEnvironment environment, Object target, Object index) throws OgnlException {
        Object result;
        if (index instanceof Number) {
            result = Array.get(target, ((Number)index).intValue());
        } else if (index instanceof DynamicSubscript) {
            int len = Array.getLength(target);
            switch (((DynamicSubscript)index).getFlag()) {
                case 3: {
                    result = Array.newInstance(target.getClass().getComponentType(), len);
                    System.arraycopy(target, 0, result, 0, len);
                    break;
                }
                case 0: {
                    int n = 0;
                    if (len > 0) {
                        n = 1;
                    }
                    result = Array.get(target, n + -1);
                    break;
                }
                case 1: {
                    result = Array.get(target, len > 0 ? len / 2 : -1);
                    break;
                }
                case 2: {
                    result = Array.get(target, len > 0 ? len - 1 : -1);
                    break;
                }
                default: {
                    throw new NoSuchPropertyException(target, index);
                }
            }
        } else {
            result = super.getIndexedPropertyValue(environment, target, index);
        }
        return result;
    }

    public void setIndexedPropertyValue(ExecutionEnvironment environment, Object target, Object index, Object value) throws OgnlException {
        boolean isNumber = index instanceof Number;
        if (isNumber || index instanceof DynamicSubscript) {
            TypeConverter converter = environment.getTypeConverter(target.getClass());
            Object convertedValue = converter.convertIndexedPropertyValue(environment, target, index, target.getClass().getComponentType(), value);
            if (isNumber) {
                Array.set(target, ((Number)index).intValue(), convertedValue);
            } else {
                int len = Array.getLength(target);
                switch (((DynamicSubscript)index).getFlag()) {
                    case 3: {
                        System.arraycopy(target, 0, convertedValue, 0, len);
                        return;
                    }
                    case 0: {
                        int n = 0;
                        if (len > 0) {
                            n = 1;
                        }
                        Array.set(target, n + -1, convertedValue);
                        break;
                    }
                    case 1: {
                        Array.set(target, len > 0 ? len / 2 : -1, convertedValue);
                        break;
                    }
                    case 2: {
                        Array.set(target, len > 0 ? len - 1 : -1, convertedValue);
                        break;
                    }
                    default: {
                        throw new NoSuchPropertyException(target, index);
                    }
                }
            }
        } else {
            super.setIndexedPropertyValue(environment, target, index, value);
        }
    }
}

