/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.seasar.kijimuna.core.ConstCore;

public class ProjectUtils
implements ConstCore {
    private static List getCommands(IProjectDescription desc, String[] ignore) throws CoreException {
        ICommand[] commands = desc.getBuildSpec();
        ArrayList<ICommand> newCommands = new ArrayList<ICommand>();
        int i = 0;
        while (i < commands.length) {
            boolean flag = true;
            int k = 0;
            while (k < ignore.length) {
                if (commands[i].getBuilderName().equals(ignore[k])) {
                    flag = false;
                    break;
                }
                ++k;
            }
            if (flag) {
                newCommands.add(commands[i]);
            } else {
                flag = true;
            }
            ++i;
        }
        return newCommands;
    }

    private static void setCommands(IProjectDescription desc, List newCommands) {
        desc.setBuildSpec(newCommands.toArray(new ICommand[newCommands.size()]));
    }

    public static void addBuilders(IProject project, String[] id) throws CoreException {
        IProjectDescription desc = project.getDescription();
        List newCommands = ProjectUtils.getCommands(desc, id);
        int i = 0;
        while (i < id.length) {
            ICommand command = desc.newCommand();
            command.setBuilderName(id[i]);
            newCommands.add(command);
            ++i;
        }
        ProjectUtils.setCommands(desc, newCommands);
        project.setDescription(desc, null);
    }

    public static void removeBuilders(IProject project, String[] id) throws CoreException {
        IProjectDescription desc = project.getDescription();
        List newCommands = ProjectUtils.getCommands(desc, id);
        ProjectUtils.setCommands(desc, newCommands);
        project.setDescription(desc, null);
    }

    public static void addNature(IProject project, String natureID) throws CoreException {
        if (project != null && project.isAccessible()) {
            IProjectDescription desc = project.getDescription();
            String[] natureIDs = desc.getNatureIds();
            int length = natureIDs.length;
            String[] newIDs = new String[length + 1];
            int i = 0;
            while (i < length) {
                if (natureIDs[i].equals(natureID)) {
                    return;
                }
                newIDs[i] = natureIDs[i];
                ++i;
            }
            newIDs[length] = natureID;
            desc.setNatureIds(newIDs);
            project.setDescription(desc, null);
        }
    }

    public static void removeNature(IProject project, String natureID) throws CoreException {
        if (project != null && project.isAccessible()) {
            IProjectDescription desc = project.getDescription();
            String[] natureIDs = desc.getNatureIds();
            int length = natureIDs.length;
            int i = 0;
            while (i < length) {
                if (natureIDs[i].equals(natureID)) {
                    String[] newIDs = new String[length - 1];
                    System.arraycopy(natureIDs, 0, newIDs, 0, i);
                    System.arraycopy(natureIDs, i + 1, newIDs, i, length - i - 1);
                    desc.setNatureIds(newIDs);
                    project.setDescription(desc, null);
                    return;
                }
                ++i;
            }
        }
    }

    public static IProjectNature getNature(IProject project, String natureID) throws CoreException {
        if (project != null && project.isOpen()) {
            return project.getNature(natureID);
        }
        return null;
    }

    public static boolean hasNature(IProject project, String natureID) {
        try {
            return ProjectUtils.getNature(project, natureID) != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static String[] getNatureIds(IProject project) {
        try {
            return project.getDescription().getNatureIds();
        }
        catch (CoreException coreException) {
            return new String[0];
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ProjectUtils.getWorkspace().getRoot();
    }

    public static IProject[] getAllProjects() {
        return ProjectUtils.getWorkspaceRoot().getProjects();
    }

    public static IProject getProject(String projectName) {
        return ProjectUtils.getWorkspaceRoot().getProject(projectName);
    }

    public static IJavaProject getJavaProject(String projectName) {
        return JavaCore.create((IProject)ProjectUtils.getProject(projectName));
    }

    public static IJavaProject getJavaProject(IResource resource) {
        return JavaCore.create((IProject)resource.getProject());
    }

    private static IPath getQualifiedDiconPath(String fullPath) {
        if (fullPath.endsWith("dicon")) {
            return new Path(fullPath);
        }
        return new Path(String.valueOf(fullPath.replace('.', '/')) + "." + "dicon");
    }

    public static IStorage findDiconStorage(IProject proj, String fullPath) {
        block11: {
            IPath path = ProjectUtils.getQualifiedDiconPath(fullPath);
            String pack = path.removeLastSegments(1).toString();
            if ((pack = pack.replace('/', '.')).startsWith(".")) {
                pack = pack.substring(1);
            }
            if (pack.endsWith(".")) {
                pack = pack.substring(0, pack.length() - 1);
            }
            String name = path.lastSegment();
            try {
                IJavaProject project = ProjectUtils.getJavaProject((IResource)proj);
                IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    IPackageFragment frag = roots[i].getPackageFragment(pack);
                    if (frag.exists()) {
                        if (frag.isDefaultPackage()) {
                            IPath testPath = roots[i].getPath().append(name);
                            IFile dicon = proj.getFile(testPath = testPath.removeFirstSegments(1));
                            if (dicon.exists()) {
                                return dicon;
                            }
                        } else {
                            Object[] resources = frag.getNonJavaResources();
                            int k = 0;
                            while (k < resources.length) {
                                IStorage dicon;
                                if (resources[k] instanceof IStorage && name.equals((dicon = (IStorage)resources[k]).getName())) {
                                    return dicon;
                                }
                                ++k;
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                IFile dicon = proj.getFile(ProjectUtils.getQualifiedDiconPath(fullPath));
                if (!dicon.exists()) break block11;
                return dicon;
            }
        }
        return null;
    }

    public static IProject getProjectFromDiconStorage(IStorage storage) {
        String fullPath = storage.getFullPath().toString();
        IProject[] projects = ProjectUtils.getAllProjects();
        int i = 0;
        while (i < projects.length) {
            IStorage test;
            if (ProjectUtils.hasNature(projects[i], "org.seasar.kijimuna.core.nature") && (test = ProjectUtils.findDiconStorage(projects[i], fullPath)) != null) {
                return projects[i];
            }
            ++i;
        }
        return null;
    }

    public static IStorage getStorage(IProject project, String fullPath) {
        IFile file = ProjectUtils.getWorkspaceRoot().getFile((IPath)new Path(fullPath));
        if (file != null && file.exists()) {
            return file;
        }
        return ProjectUtils.findDiconStorage(project, fullPath);
    }

    public static String getPathString(IStorage storage) {
        return storage.getFullPath().toString();
    }

    public static String getResourceLoaderPath(IStorage storage) {
        IPath path = storage.getFullPath();
        if (storage instanceof IFile) {
            IContainer folder = ((IFile)storage).getParent();
            IJavaElement pack = JavaCore.create((IResource)folder);
            do {
                if (!(pack instanceof IPackageFragmentRoot)) continue;
                int depth = pack.getPath().segmentCount();
                return path.removeFirstSegments(depth).toString();
            } while (pack instanceof IPackageFragment && (pack = pack.getParent()) != null);
        } else {
            return path.toString();
        }
        return path.removeFirstSegments(1).toString();
    }
}

