/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.util;

import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.Kijimuna;
import org.seasar.kijimuna.core.preference.IPreferences;

public class MarkerUtils
implements ConstCore {
    private static int getSystemSeverity(int severity) {
        switch (severity) {
            case 0: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
        }
        return -1;
    }

    public static void createMarker(String type, String category, int severity, IResource resource, int line, String message) {
        if (severity == 0 || severity == 1 || severity == 2) {
            try {
                IMarker marker = resource.createMarker(type);
                HashMap<String, Object> map = new HashMap<String, Object>(4);
                int systemSeverity = MarkerUtils.getSystemSeverity(severity);
                map.put("severity", new Integer(systemSeverity));
                if (line < 1) {
                    line = 1;
                }
                map.put("lineNumber", new Integer(line));
                map.put("category", category);
                map.put("message", message);
                marker.setAttributes(map);
            }
            catch (CoreException e) {
                Kijimuna.reportException((Exception)((Object)e));
            }
        }
    }

    public static void deleteMarker(IResource resource, String type) {
        try {
            resource.deleteMarkers(type, true, 2);
        }
        catch (CoreException e) {
            Kijimuna.reportException((Exception)((Object)e));
        }
    }

    public static void removeAllMarker(String type) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        MarkerUtils.deleteMarker((IResource)root, type);
    }

    public static IMarker[] findMarker(IResource resource, String type) {
        try {
            return resource.findMarkers(type, true, 2);
        }
        catch (CoreException e) {
            Kijimuna.reportException((Exception)((Object)e));
            return new IMarker[0];
        }
    }

    public static void changeMarkerSeverity(IResource resource, String type, IPreferences pref) {
        IMarker[] markers = MarkerUtils.findMarker(resource, type);
        int i = 0;
        while (i < markers.length) {
            try {
                String category = (String)markers[i].getAttribute("category");
                if (category != null) {
                    int severity = pref.getInt(category);
                    markers[i].setAttribute("severity", MarkerUtils.getSystemSeverity(severity));
                }
            }
            catch (CoreException e) {
                Kijimuna.reportException((Exception)((Object)e));
            }
            ++i;
        }
    }
}

