/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.rtti.ognl;

import org.ognl.el.Expression;
import org.ognl.el.Extensions;
import org.ognl.el.OgnlException;
import org.ognl.el.PropertyAccessor;
import org.ognl.el.extensions.DefaultExecutionEnvironment;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.rtti.RttiLoader;
import org.seasar.kijimuna.core.rtti.ognl.OgnlExtensions;

public class OgnlRtti {
    private DefaultExecutionEnvironment environment;
    private OgnlExtensions extensions;
    private RttiLoader rootLoader;

    public OgnlRtti(RttiLoader rootLoader) {
        this.rootLoader = rootLoader;
        this.extensions = new OgnlExtensions(rootLoader);
        this.environment = new DefaultExecutionEnvironment();
        this.environment.setExtensions((Extensions)this.extensions);
    }

    public void setVariableValue(String key, Object value) {
        this.environment.setVariableValue(key, value);
    }

    public void setPropertyAccessor(Class clazz, PropertyAccessor accessor) {
        this.extensions.setPropertyAccessor(clazz, accessor);
    }

    public IRtti getValue(Object root, String el) throws OgnlException {
        Expression expression = this.environment.parseExpression(el);
        Object ret = this.environment.getValue(expression, root);
        if (ret != null) {
            if (ret instanceof IRtti) {
                return (IRtti)ret;
            }
            return this.rootLoader.loadRtti(ret.getClass());
        }
        return null;
    }
}

