/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.rtti.ognl;

import org.ognl.el.ExecutionEnvironment;
import org.ognl.el.Extensions;
import org.ognl.el.MethodFailedException;
import org.ognl.el.OgnlException;
import org.ognl.el.PropertyAccessor;
import org.ognl.util.ClassRegistry;
import org.seasar.kijimuna.core.Kijimuna;
import org.seasar.kijimuna.core.rtti.HasErrorRtti;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.rtti.IRttiConstructorDesctiptor;
import org.seasar.kijimuna.core.rtti.IRttiFieldDescriptor;
import org.seasar.kijimuna.core.rtti.IRttiMethodDesctiptor;
import org.seasar.kijimuna.core.rtti.IRttiPropertyDescriptor;
import org.seasar.kijimuna.core.rtti.RttiLoader;
import org.seasar.kijimuna.core.rtti.ognl.OgnlRttiUnprocessable;

public class OgnlExtensions
extends Extensions {
    private RttiLoader loader;
    private ClassRegistry accessors = new ClassRegistry();

    public OgnlExtensions(RttiLoader loader) {
        this.loader = loader;
    }

    private IRtti convert(RttiLoader localLoader, Object obj) throws OgnlRttiUnprocessable {
        if (obj instanceof IRtti) {
            if (obj instanceof HasErrorRtti) {
                String message = ((HasErrorRtti)obj).getErrorMessage();
                throw new OgnlRttiUnprocessable(message);
            }
            return (IRtti)obj;
        }
        return localLoader.loadRtti(obj.getClass());
    }

    private IRtti[] convertArgs(RttiLoader localLoader, Object[] args) throws OgnlRttiUnprocessable {
        if (args != null) {
            IRtti[] rttiArgs = new IRtti[args.length];
            int i = 0;
            while (i < args.length) {
                if (args[i] != null) {
                    rttiArgs[i] = this.convert(localLoader, args[i]);
                }
                ++i;
            }
            return rttiArgs;
        }
        return new IRtti[0];
    }

    private IRtti invoke(IRtti rtti, String methodName, Object[] args, boolean staticAccess) throws OgnlRttiUnprocessable {
        RttiLoader localLoader = rtti.getRttiLoader();
        IRtti[] rttiArgs = this.convertArgs(localLoader, args);
        IRttiMethodDesctiptor descriptor = rtti.getMethod(methodName, rttiArgs, staticAccess);
        if (descriptor != null) {
            return descriptor.getReturnType();
        }
        return this.loader.loadHasErrorRtti(null, Kijimuna.getResourceString("rtti.ognl.OgnlExtensions.1", new Object[]{rtti.getQualifiedName(), methodName, rttiArgs}));
    }

    private PropertyAccessor getPropertyAccessor(Class forClass) {
        return (PropertyAccessor)this.accessors.get(forClass);
    }

    public void setPropertyAccessor(Class forClass, PropertyAccessor accessor) {
        this.accessors.put(forClass, (Object)accessor);
    }

    public Object callArrayConstructor(ExecutionEnvironment environment, String componentClassName, Object[] args) throws OgnlException {
        return this.loader.loadRtti(String.valueOf(componentClassName) + "[]");
    }

    public Object callConstructor(ExecutionEnvironment environment, String targetClassName, Object[] args) throws OgnlException {
        IRtti rtti = this.loader.loadRtti(targetClassName);
        if (rtti instanceof HasErrorRtti) {
            return rtti;
        }
        IRtti[] rttiArgs = this.convertArgs(this.loader, args);
        IRttiConstructorDesctiptor descriptor = rtti.getConstructor(rttiArgs);
        if (descriptor != null) {
            return rtti;
        }
        return this.loader.loadHasErrorRtti(null, Kijimuna.getResourceString("rtti.ognl.OgnlExtensions.2", new Object[]{targetClassName, rtti.getShortName(), rttiArgs}));
    }

    public Object callMethod(ExecutionEnvironment environment, Object target, String methodName, Object[] args) throws MethodFailedException, OgnlException {
        IRtti rtti = this.convert(this.loader, target);
        if (rtti instanceof HasErrorRtti) {
            return rtti;
        }
        return this.invoke(rtti, methodName, args, false);
    }

    public Object callStaticMethod(ExecutionEnvironment environment, String targetClassName, String methodName, Object[] args) throws MethodFailedException, OgnlException {
        IRtti rtti = this.loader.loadRtti(targetClassName);
        if (rtti instanceof HasErrorRtti) {
            return rtti;
        }
        return this.invoke(rtti, methodName, args, true);
    }

    public Object getIndexedPropertyValue(ExecutionEnvironment environment, Object source, Object index) throws OgnlException {
        throw new OgnlRttiUnprocessable();
    }

    public Object getNamedIndexedPropertyValue(ExecutionEnvironment environment, Object source, String propertyName, Object index) throws OgnlException {
        throw new OgnlRttiUnprocessable();
    }

    public Object getPropertyValue(ExecutionEnvironment environment, Object source, Object property) throws OgnlException {
        PropertyAccessor accessor = this.getPropertyAccessor(source.getClass());
        if (accessor != null) {
            return accessor.getPropertyValue(environment, source, property);
        }
        IRtti rtti = this.convert(this.loader, source);
        if (rtti instanceof HasErrorRtti) {
            return rtti;
        }
        String propertyName = property.toString();
        IRttiPropertyDescriptor prop = rtti.getProperty(propertyName);
        if (prop != null && prop.isReadable()) {
            return prop.getType();
        }
        IRttiFieldDescriptor field = rtti.getField(propertyName, false);
        if (field != null) {
            return field.getType();
        }
        return this.loader.loadHasErrorRtti(null, Kijimuna.getResourceString("rtti.ognl.OgnlExtensions.3", new Object[]{rtti.getQualifiedName(), propertyName}));
    }

    public Object getStaticFieldValue(ExecutionEnvironment environment, String targetClassName, String fieldName) throws OgnlException {
        IRtti rtti = this.loader.loadRtti(targetClassName);
        if (rtti instanceof HasErrorRtti) {
            return rtti;
        }
        IRttiFieldDescriptor field = rtti.getField(fieldName, true);
        if (field != null) {
            return field.getType();
        }
        return this.loader.loadHasErrorRtti(null, Kijimuna.getResourceString("rtti.ognl.OgnlExtensions.4", new Object[]{rtti.getQualifiedName(), fieldName}));
    }

    public void setIndexedPropertyValue(ExecutionEnvironment environment, Object target, Object index, Object value) throws OgnlException {
        throw new OgnlRttiUnprocessable();
    }

    public void setNamedIndexedPropertyValue(ExecutionEnvironment environment, Object target, String propertyName, Object index, Object value) throws OgnlException {
        throw new OgnlRttiUnprocessable();
    }

    public void setPropertyValue(ExecutionEnvironment environment, Object target, Object property, Object value) throws OgnlException {
        PropertyAccessor accessor = this.getPropertyAccessor(target.getClass());
        if (accessor != null) {
            accessor.setPropertyValue(environment, target, property, value);
        } else {
            IRttiFieldDescriptor field;
            IRtti rtti = this.convert(this.loader, target);
            if (rtti instanceof HasErrorRtti) {
                return;
            }
            String propertyName = property.toString();
            IRtti rttiValue = this.convert(this.loader, value);
            IRttiPropertyDescriptor prop = rtti.getProperty(propertyName);
            if (!(prop != null && prop.isWritable() && !prop.getType().isAssignableFrom(rttiValue) || (field = rtti.getField(propertyName, false)) != null && !field.isFinal() && field.getType().isAssignableFrom(rttiValue))) {
                throw new OgnlRttiUnprocessable(Kijimuna.getResourceString("rtti.ognl.OgnlExtensions.5", new Object[]{rtti.getQualifiedName(), propertyName}));
            }
        }
    }
}

