/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.rtti;

import java.util.HashSet;
import java.util.Set;
import org.seasar.kijimuna.core.rtti.AbstractRttiValuableDescriptor;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.rtti.IRttiPropertyDescriptor;

class DefaultRttiPropertyDescriptor
extends AbstractRttiValuableDescriptor
implements IRttiPropertyDescriptor {
    private Set writableType;
    private boolean readable;
    private boolean writable;

    DefaultRttiPropertyDescriptor(IRtti parent, String name, IRtti type, boolean isReadable) {
        super(parent, name, type);
        if (isReadable) {
            this.readable = true;
        } else {
            this.writable = true;
        }
        this.writableType = new HashSet();
    }

    public void doReadable(IRtti type) {
        if (!this.readable || type.getQualifiedName().equals("boolean")) {
            this.setType(type);
        }
        this.readable = true;
        this.writable = this.writableType.contains(type);
    }

    public void doWritable(IRtti type) {
        if (this.readable && this.getType().equals(type)) {
            this.writable = true;
        }
        this.writableType.add(type);
    }

    public boolean equals(Object test) {
        if (test instanceof IRttiPropertyDescriptor) {
            IRttiPropertyDescriptor desc = (IRttiPropertyDescriptor)test;
            return this.getParent().equals(desc.getParent()) && this.getName().equals(desc.getName());
        }
        return false;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public int compareTo(Object test) {
        if (test instanceof IRttiPropertyDescriptor) {
            IRttiPropertyDescriptor prop = (IRttiPropertyDescriptor)test;
            return this.getName().compareTo(prop.getName());
        }
        return 1;
    }
}

