/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.rtti;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.seasar.kijimuna.core.rtti.DefaultRttiConstructorDescriptor;
import org.seasar.kijimuna.core.rtti.DefaultRttiFieldDescriptor;
import org.seasar.kijimuna.core.rtti.DefaultRttiMethodDescriptor;
import org.seasar.kijimuna.core.rtti.DefaultRttiPropertyDescriptor;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.rtti.IRttiConstructorDesctiptor;
import org.seasar.kijimuna.core.rtti.IRttiFieldDescriptor;
import org.seasar.kijimuna.core.rtti.IRttiInvokableDesctiptor;
import org.seasar.kijimuna.core.rtti.IRttiMethodDesctiptor;
import org.seasar.kijimuna.core.rtti.IRttiPropertyDescriptor;
import org.seasar.kijimuna.core.rtti.RttiLoader;
import org.seasar.kijimuna.core.util.ProjectUtils;

class DefaultRtti
implements IRtti {
    private static final Map WRAPPERS = new HashMap();
    private transient IType thisType;
    private RttiLoader loader;
    private String projectName;
    private String qualifiedName;
    private boolean primitive;
    private int arrayDepth;
    private IRtti arrayItem;
    private boolean autoConvert;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        WRAPPERS.put("java.lang.Boolean", "boolean");
        WRAPPERS.put("java.lang.Byte", "byte");
        WRAPPERS.put("java.lang.Character", "char");
        WRAPPERS.put("java.lang.Double", "double");
        WRAPPERS.put("java.lang.Float", "float");
        WRAPPERS.put("java.lang.Integer", "int");
        WRAPPERS.put("java.lang.Long", "long");
        WRAPPERS.put("java.lang.Short", "short");
        WRAPPERS.put("java.lang.Void", "void");
    }

    public static boolean isMatchArgs(IRtti[] source, IRtti[] test) {
        if (test == null) {
            test = new IRtti[]{};
        }
        if (source.length == test.length) {
            boolean match = true;
            int k = 0;
            while (k < source.length) {
                if (!source[k].isAssignableFrom(test[k])) {
                    match = false;
                    break;
                }
                ++k;
            }
            if (match) {
                return true;
            }
        }
        return false;
    }

    DefaultRtti(RttiLoader loader, IType thisType, String qualifiedName, boolean primitive, int arrayDepth, IRtti arrayItem, boolean autoConvert) {
        this.loader = loader;
        this.thisType = thisType;
        this.qualifiedName = qualifiedName;
        this.primitive = primitive;
        this.arrayDepth = arrayDepth;
        this.arrayItem = arrayItem;
        this.autoConvert = autoConvert;
        this.projectName = loader.getProject().getElementName();
    }

    private boolean isTypeAvailable() {
        return this.getType() != null;
    }

    private boolean isArray() {
        return this.arrayDepth > 0;
    }

    private boolean isPrimitive() {
        return this.primitive;
    }

    private String getWrapperName() {
        return this.qualifiedName;
    }

    private IRtti getArrayItemClass() {
        if (this.isArray()) {
            return this.arrayItem;
        }
        return null;
    }

    private boolean isWideningPrimitiveConversion(IRtti testRtti) {
        String thisQName = this.getQualifiedName();
        String testQName = testRtti.getQualifiedName();
        if (this.autoConvert) {
            if (WRAPPERS.containsKey(thisQName)) {
                thisQName = WRAPPERS.get(thisQName).toString();
            }
            if (WRAPPERS.containsKey(testQName)) {
                testQName = WRAPPERS.get(testQName).toString();
            }
        }
        if (testQName.equals("byte")) {
            return "short,int,long,float,double".indexOf(thisQName) != -1;
        }
        if (testQName.equals("short")) {
            return "int,long,float,double".indexOf(thisQName) != -1;
        }
        if (testQName.equals("char")) {
            return "int,long,float,double".indexOf(thisQName) != -1;
        }
        if (testQName.equals("int")) {
            return "long,float,double".indexOf(thisQName) != -1;
        }
        if (testQName.equals("long")) {
            return "float,double".indexOf(thisQName) != -1;
        }
        if (testQName.equals("float")) {
            return "double".indexOf(thisQName) != -1;
        }
        return false;
    }

    private boolean isWideningArrayConversion(IRtti testRtti) {
        String thisQName = this.getQualifiedName();
        if (thisQName.equals("java.lang.Object") || thisQName.equals("java.lang.Cloneable") || thisQName.equals("java.io.Serializable")) {
            return true;
        }
        IRtti thisArray = this.getArrayItemClass();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.kijimuna.core.rtti.DefaultRtti$RttiInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RttiInfo testInfo = (RttiInfo)testRtti.getAdapter(clazz);
        IRtti testArray = testInfo.getArrayItemClass();
        return thisArray != null && testArray != null && thisArray.isAssignableFrom(testArray);
    }

    private boolean isPublicMember(IMember member) {
        if (!this.isInterface()) {
            try {
                int flags = member.getFlags();
                if (!Flags.isPublic((int)flags)) {
                    return false;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return true;
    }

    private String createDescriptorKey(IRttiInvokableDesctiptor descriptor) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(descriptor.getMethodName()).append("(");
        IRtti[] args = descriptor.getArgs();
        int i = 0;
        while (i < args.length) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(args[i].getQualifiedName());
            ++i;
        }
        return buffer.toString();
    }

    private Map getInvokableMap(Pattern pattern, boolean isConstructor) {
        HashMap<String, IRttiConstructorDesctiptor> descriptors = new HashMap<String, IRttiConstructorDesctiptor>();
        if (this.isTypeAvailable()) {
            try {
                DefaultRtti superClass;
                IMethod[] methods = this.getType().getMethods();
                int i = 0;
                while (i < methods.length) {
                    String methodName;
                    if (this.isPublicMember((IMember)methods[i]) && pattern.matcher(methodName = methods[i].getElementName()).matches()) {
                        IRttiInvokableDesctiptor descriptor = isConstructor ? this.createConstructorDescriptor(methods[i]) : this.createMethodDescriptor(methods[i]);
                        descriptors.put(this.createDescriptorKey(descriptor), (IRttiConstructorDesctiptor)descriptor);
                    }
                    ++i;
                }
                if (!isConstructor && (superClass = (DefaultRtti)this.getSuperClass()) != null) {
                    Map superMethods = superClass.getInvokableMap(pattern, isConstructor);
                    Iterator it = superMethods.keySet().iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        if (descriptors.containsKey(key)) continue;
                        descriptors.put(key, (IRttiConstructorDesctiptor)superMethods.get(key));
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return descriptors;
    }

    private IRttiConstructorDesctiptor createConstructorDescriptor(IMethod constructor) {
        return new DefaultRttiConstructorDescriptor((IMember)constructor, this, false);
    }

    private IRttiMethodDesctiptor createMethodDescriptor(IMethod method) {
        return new DefaultRttiMethodDescriptor(method, (IRtti)this);
    }

    private IRttiConstructorDesctiptor createDefaultConstructor() {
        try {
            IMethod[] methods = this.getType().getMethods();
            String shortName = this.getShortName();
            int i = 0;
            while (i < methods.length) {
                if (methods[i].getElementName().equals(shortName) && methods[i].getParameterTypes().length == 0) {
                    return null;
                }
                ++i;
            }
            return new DefaultRttiConstructorDescriptor((IMember)this.getType(), this, true);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private String getPropertyType(IMethod method, String returnType, int parameterNum) {
        block4: {
            try {
                String[] args = method.getParameterTypes();
                if (args.length != parameterNum) break block4;
                if (parameterNum == 0) {
                    String ret = Signature.toString((String)method.getReturnType());
                    if (returnType == null || returnType.equals(ret)) {
                        return ret;
                    }
                    break block4;
                }
                return Signature.toString((String)args[0]);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private DefaultRttiPropertyDescriptor getPropertyDescriptor(IMethod method) {
        String propertyType;
        boolean isReader;
        String propertyName;
        String methodName = method.getElementName();
        if (methodName.startsWith("set")) {
            propertyName = methodName.substring(3);
            isReader = false;
            propertyType = this.getPropertyType(method, "void", 1);
        } else if (methodName.startsWith("get")) {
            propertyName = methodName.substring(3);
            isReader = true;
            propertyType = this.getPropertyType(method, null, 0);
        } else if (methodName.startsWith("is")) {
            propertyName = methodName.substring(2);
            isReader = true;
            propertyType = this.getPropertyType(method, "boolean", 0);
        } else {
            return null;
        }
        if (propertyType == null) {
            return null;
        }
        if (propertyName.length() == 0 || Character.isLowerCase(propertyName.charAt(0))) {
            return null;
        }
        if (propertyName.length() == 1 || Character.isLowerCase(propertyName.charAt(1))) {
            char[] chars = propertyName.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            propertyName = new String(chars);
        }
        IRtti propertyRtti = this.loader.loadRtti(propertyType);
        return new DefaultRttiPropertyDescriptor(this, propertyName, propertyRtti, isReader);
    }

    private void margePropertyDescriptor(Map map, DefaultRttiPropertyDescriptor descriptor) {
        String propertyName = descriptor.getName();
        DefaultRttiPropertyDescriptor old = (DefaultRttiPropertyDescriptor)map.get(propertyName);
        if (old != null) {
            IRtti propertyType = descriptor.getType();
            boolean isReadable = descriptor.isReadable();
            boolean isWritable = descriptor.isWritable();
            if (propertyType.equals(old.getType())) {
                if (isReadable) {
                    old.doReadable(propertyType);
                }
                if (isWritable) {
                    old.doWritable(propertyType);
                }
            }
        } else {
            map.put(propertyName, descriptor);
        }
    }

    private Map getPropertyMap() {
        if (this.isTypeAvailable()) {
            try {
                IRttiPropertyDescriptor[] props;
                IMethod[] methods = this.getType().getMethods();
                HashMap map = new HashMap();
                int i = 0;
                while (i < methods.length) {
                    DefaultRttiPropertyDescriptor descriptor;
                    if (this.isPublicMember((IMember)methods[i]) && (descriptor = this.getPropertyDescriptor(methods[i])) != null) {
                        this.margePropertyDescriptor(map, descriptor);
                    }
                    ++i;
                }
                IRtti parent = this.getSuperClass();
                if (parent != null && (props = parent.getProperties()) != null) {
                    int i2 = 0;
                    while (i2 < props.length) {
                        this.margePropertyDescriptor(map, (DefaultRttiPropertyDescriptor)props[i2]);
                        ++i2;
                    }
                }
                return map;
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    public boolean equals(Object test) {
        if (test != null && test instanceof IRtti) {
            IRtti testRtti = (IRtti)test;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.seasar.kijimuna.core.rtti.DefaultRtti$RttiInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            RttiInfo testInfo = (RttiInfo)testRtti.getAdapter(clazz);
            if (this.autoConvert && (this.isPrimitive() || testInfo.isPrimitive()) && this.getWrapperName().equals(testInfo.getWrapperName())) {
                return true;
            }
            if (this.isArray()) {
                if (testInfo.isArray()) {
                    IRtti thisArrayItem = this.getArrayItemClass();
                    IRtti testArrayItem = testInfo.getArrayItemClass();
                    return thisArrayItem.equals(testArrayItem);
                }
                return false;
            }
            String qname = testRtti.getQualifiedName();
            if (this.getQualifiedName().equals(qname)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.kijimuna.core.rtti.DefaultRtti$RttiInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return new RttiInfo(this);
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IStorage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(adapter)) {
            IResource resource;
            IType type;
            if (this.isTypeAvailable() && (type = this.getType()) != null && (resource = type.getResource()) != null) {
                return resource;
            }
        } else {
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("org.seasar.kijimuna.core.rtti.IRtti");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz3.equals(adapter)) {
                return this;
            }
        }
        return null;
    }

    public IType getType() {
        if (this.thisType == null) {
            IJavaProject project = ProjectUtils.getJavaProject(this.projectName);
            try {
                this.thisType = project.findType(this.qualifiedName);
            }
            catch (JavaModelException javaModelException) {}
        }
        return this.thisType;
    }

    public RttiLoader getRttiLoader() {
        return this.loader;
    }

    public boolean isInterface() {
        if (this.isTypeAvailable()) {
            try {
                return this.getType().isInterface();
            }
            catch (JavaModelException javaModelException) {}
        }
        return false;
    }

    public boolean isFinal() {
        if (this.isTypeAvailable()) {
            try {
                return Flags.isFinal((int)this.getType().getFlags());
            }
            catch (JavaModelException javaModelException) {}
        }
        return false;
    }

    public boolean isAssignableFrom(IRtti testRtti) {
        if (testRtti == null) {
            return true;
        }
        if (this.equals(testRtti)) {
            return true;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.kijimuna.core.rtti.DefaultRtti$RttiInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RttiInfo testInfo = (RttiInfo)testRtti.getAdapter(clazz);
        if (this.isPrimitive() || testInfo.isPrimitive()) {
            return this.isWideningPrimitiveConversion(testRtti);
        }
        if (testInfo.isArray()) {
            return this.isWideningArrayConversion(testRtti);
        }
        if (this.isInterface()) {
            IRtti[] superInterfaces = testRtti.getInterfaces();
            int i = 0;
            while (i < superInterfaces.length) {
                if (this.equals(superInterfaces[i])) {
                    return true;
                }
                ++i;
            }
        }
        if (testRtti.isInterface()) {
            return this.getQualifiedName().equals("java.lang.Object");
        }
        IRtti superClass = testRtti.getSuperClass();
        if (superClass == null) {
            return false;
        }
        return this.isAssignableFrom(superClass);
    }

    public String getQualifiedName() {
        if (this.isArray()) {
            StringBuffer buffer = new StringBuffer(this.arrayItem.getQualifiedName());
            int i = 0;
            while (i < this.arrayDepth) {
                buffer.append("[]");
                ++i;
            }
            return buffer.toString();
        }
        if (this.isPrimitive()) {
            return (String)WRAPPERS.get(this.qualifiedName);
        }
        return this.qualifiedName;
    }

    public String getShortName() {
        String qname = this.getQualifiedName();
        int pos = qname.lastIndexOf(46);
        if (pos != -1) {
            return qname.substring(pos + 1);
        }
        return qname;
    }

    public IRtti[] getInterfaces() {
        if (this.isTypeAvailable()) {
            try {
                String[] interfaces = this.getType().getSuperInterfaceNames();
                IRtti[] ret = new IRtti[interfaces.length];
                int i = 0;
                while (i < interfaces.length) {
                    ret[i] = this.loader.loadRtti(interfaces[i]);
                    ++i;
                }
                return ret;
            }
            catch (Exception exception) {}
        }
        return new IRtti[0];
    }

    public IRtti getSuperClass() {
        if (this.isTypeAvailable() && !this.isInterface() && !this.getQualifiedName().equals("java.lang.Object")) {
            try {
                String superClassName = this.getType().getSuperclassName();
                if (superClassName == null) {
                    superClassName = "java.lang.Object";
                }
                return this.loader.loadRtti(superClassName);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public IRttiFieldDescriptor getField(String name, boolean staticAccess) {
        try {
            if (name.equals("class") && staticAccess) {
                return new DefaultRttiFieldDescriptor(this, name, this.loader.loadRtti("java.lang.Class"), true, true);
            }
            if (this.isArray() && "length".equals(name)) {
                return new DefaultRttiFieldDescriptor(this, name, this.loader.loadRtti("int"), true, false);
            }
            if (this.isTypeAvailable()) {
                IField value = this.getType().getField(name);
                if (value.exists() && this.isPublicMember((IMember)value)) {
                    int flags = value.getFlags();
                    if (staticAccess && !Flags.isStatic((int)flags)) {
                        return null;
                    }
                    String typeSignature = Signature.toString((String)value.getTypeSignature());
                    return new DefaultRttiFieldDescriptor(this, name, this.loader.loadRtti(typeSignature), Flags.isFinal((int)flags), Flags.isStatic((int)flags));
                }
                IRtti[] interfaces = this.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    IRttiFieldDescriptor ret = interfaces[i].getField(name, staticAccess);
                    if (ret != null) {
                        return ret;
                    }
                    ++i;
                }
                IRtti superClass = this.getSuperClass();
                if (superClass != null) {
                    return superClass.getField(name, staticAccess);
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public IRttiConstructorDesctiptor getConstructor(IRtti[] args) {
        IRttiConstructorDesctiptor[] constructors = this.getConstructors();
        if (constructors.length > 0) {
            int i = 0;
            while (i < constructors.length) {
                IRtti[] rttiArgs = constructors[i].getArgs();
                if (DefaultRtti.isMatchArgs(rttiArgs, args)) {
                    return constructors[i];
                }
                ++i;
            }
        } else if (args == null || args.length == 0) {
            return this.createDefaultConstructor();
        }
        return null;
    }

    public IRttiConstructorDesctiptor[] getConstructors() {
        Pattern pattern = Pattern.compile(this.getShortName());
        Map descriptors = this.getInvokableMap(pattern, true);
        if (descriptors.size() == 0) {
            IRttiConstructorDesctiptor def = this.createDefaultConstructor();
            if (def != null) {
                return new IRttiConstructorDesctiptor[]{def};
            }
            return new IRttiConstructorDesctiptor[0];
        }
        IRttiConstructorDesctiptor[] ret = new IRttiConstructorDesctiptor[descriptors.size()];
        int i = 0;
        Iterator it = descriptors.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ret[i] = (IRttiConstructorDesctiptor)entry.getValue();
            ++i;
        }
        return ret;
    }

    public IRttiMethodDesctiptor getMethod(String methodName, IRtti[] args, boolean staticAccess) {
        Pattern pattern = Pattern.compile(methodName);
        IRttiMethodDesctiptor[] methods = this.getMethods(pattern);
        if (methods.length > 0) {
            int i = 0;
            while (i < methods.length) {
                IRtti[] rttiArgs;
                if ((!staticAccess || methods[i].isStatic()) && DefaultRtti.isMatchArgs(rttiArgs = methods[i].getArgs(), args)) {
                    return methods[i];
                }
                ++i;
            }
        }
        return null;
    }

    public IRttiMethodDesctiptor[] getMethods(Pattern pattern) {
        Map descriptors = this.getInvokableMap(pattern, false);
        IRttiMethodDesctiptor[] ret = new IRttiMethodDesctiptor[descriptors.size()];
        int i = 0;
        Iterator it = descriptors.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ret[i] = (IRttiMethodDesctiptor)entry.getValue();
            ++i;
        }
        return ret;
    }

    public IRttiPropertyDescriptor getProperty(String name) {
        if (this.isTypeAvailable()) {
            Map map = this.getPropertyMap();
            return (IRttiPropertyDescriptor)map.get(name);
        }
        return null;
    }

    public IRttiPropertyDescriptor[] getProperties() {
        if (this.isTypeAvailable()) {
            Map map = this.getPropertyMap();
            IRttiPropertyDescriptor[] ret = new IRttiPropertyDescriptor[map.size()];
            Iterator it = map.entrySet().iterator();
            int i = 0;
            while (i < ret.length && it.hasNext()) {
                Map.Entry entry = it.next();
                ret[i] = (IRttiPropertyDescriptor)entry.getValue();
                ++i;
            }
            return ret;
        }
        return new IRttiPropertyDescriptor[0];
    }

    private class RttiInfo {
        private DefaultRtti rtti;

        RttiInfo(DefaultRtti rtti) {
            this.rtti = rtti;
        }

        boolean isArray() {
            return this.rtti.isArray();
        }

        boolean isPrimitive() {
            return this.rtti.isPrimitive();
        }

        String getWrapperName() {
            return this.rtti.getWrapperName();
        }

        IRtti getArrayItemClass() {
            return this.rtti.getArrayItemClass();
        }
    }
}

