/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.rtti;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.seasar.kijimuna.core.rtti.DefaultRtti;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.rtti.IRttiInvokableDesctiptor;
import org.seasar.kijimuna.core.rtti.RttiLoader;

abstract class AbstractRttiInvokableDescriptor
implements IRttiInvokableDesctiptor {
    private transient IMember member;
    private boolean isIMethod;
    private IRtti parent;
    private String methodName;
    private IRtti returnType;
    private IRtti[] args;
    private boolean fFinal;
    private boolean fStatic;
    private IRtti[] values;

    AbstractRttiInvokableDescriptor(IMember member, IRtti parent) {
        if (member instanceof IMethod) {
            this.isIMethod = true;
        }
        this.member = member;
        this.parent = parent;
        this.methodName = member.getElementName();
        this.returnType = this.createReturnType(member, parent.getRttiLoader());
        this.args = this.createArgRttis(member, parent.getRttiLoader());
        this.fFinal = this.isFinal(member);
        this.fStatic = this.isStatic(member);
    }

    private IRtti createReturnType(IMember member, RttiLoader loader) {
        if (member instanceof IMethod) {
            IMethod method = (IMethod)member;
            try {
                String retType = method.getReturnType();
                String resolvedRet = Signature.toString((String)retType);
                return loader.loadRtti(resolvedRet);
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return loader.loadRtti("void");
    }

    private IRtti[] createArgRttis(IMember member, RttiLoader loader) {
        if (member instanceof IMethod) {
            IMethod method = (IMethod)member;
            String[] argTypes = method.getParameterTypes();
            IRtti[] rttiArgs = new IRtti[argTypes.length];
            int k = 0;
            while (k < argTypes.length) {
                String resolvedName = Signature.toString((String)argTypes[k]);
                rttiArgs[k] = loader.loadRtti(resolvedName);
                ++k;
            }
            return rttiArgs;
        }
        return new IRtti[0];
    }

    private boolean isFinal(IMember member) {
        if (member instanceof IMethod) {
            try {
                int flag = member.getFlags();
                return Flags.isFinal((int)flag);
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return false;
    }

    private boolean isStatic(IMember member) {
        if (member instanceof IMethod) {
            try {
                int flag = member.getFlags();
                return Flags.isStatic((int)flag);
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return false;
    }

    private String[] reverseArgRttis() {
        boolean binary = this.parent.getType().isBinary();
        String[] signature = new String[this.args.length];
        int i = 0;
        while (i < this.args.length) {
            String qname = this.args[i].getQualifiedName();
            signature[i] = Signature.createTypeSignature((String)qname, (boolean)binary);
            ++i;
        }
        return signature;
    }

    private IMember findIMethod() {
        IType type = this.parent.getType();
        IMethod method = type.getMethod(this.methodName, this.reverseArgRttis());
        if (!this.methodName.equals(this.parent.getShortName())) {
            while (method == null) {
                try {
                    String superClassName = type.getSuperclassName();
                    if (superClassName == null) {
                        superClassName = "java.lang.Object";
                    }
                    IType superType = type.getJavaProject().findType(superClassName);
                    method = superType.getMethod(this.methodName, this.reverseArgRttis());
                }
                catch (Exception exception) {}
            }
        }
        if (method != null) {
            return method;
        }
        return type;
    }

    public boolean equals(Object test) {
        if (test instanceof IRttiInvokableDesctiptor) {
            IRttiInvokableDesctiptor desc = (IRttiInvokableDesctiptor)test;
            return this.parent.equals(desc.getParent()) && this.getMethodName().equals(desc.getMethodName()) && DefaultRtti.isMatchArgs(this.args, desc.getArgs());
        }
        return false;
    }

    public IMember getMember() {
        if (this.member != null) {
            return this.member;
        }
        if (this.isIMethod) {
            return this.findIMethod();
        }
        return this.parent.getType();
    }

    public IRtti getParent() {
        return this.parent;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public IRtti getReturnType() {
        return this.returnType;
    }

    public IRtti[] getArgs() {
        return this.args;
    }

    public boolean isFinal() {
        return this.fFinal;
    }

    public boolean isStatic() {
        return this.fStatic;
    }

    public IRtti[] getValues() {
        return this.values;
    }

    public void setValues(IRtti[] values) {
        this.values = values;
    }

    public int compareTo(Object test) {
        if (test instanceof IRttiInvokableDesctiptor) {
            IRttiInvokableDesctiptor invokabler = (IRttiInvokableDesctiptor)test;
            return this.getArgs().length - invokabler.getArgs().length;
        }
        return 1;
    }
}

