/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.project;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.seasar.kijimuna.core.project.IFileProcessor;
import org.seasar.kijimuna.core.util.FileUtils;
import org.seasar.kijimuna.core.util.ProjectUtils;

public class ResourceVisitor
implements IResourceVisitor {
    private String natureID;
    private IFileProcessor builder;
    private IProgressMonitor monitor;

    public ResourceVisitor(String natureID, IFileProcessor builder, IProgressMonitor monitor) {
        this.natureID = natureID;
        this.builder = builder;
        this.monitor = monitor;
    }

    public boolean visit(IResource resource) throws CoreException {
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            if (project.isOpen() && ProjectUtils.getNature(project, this.natureID) != null) {
                this.builder.handlePrepareFullProcess(project, this.monitor);
                return true;
            }
        } else {
            if (resource instanceof IFolder) {
                return true;
            }
            if (resource instanceof IFile && FileUtils.isInJavaSourceFolder((IFile)resource)) {
                IFile file = (IFile)resource;
                this.builder.handleFileAdded(file, true, this.monitor);
            }
        }
        return false;
    }
}

