/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.project;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.seasar.kijimuna.core.project.IFileProcessor;
import org.seasar.kijimuna.core.util.FileUtils;
import org.seasar.kijimuna.core.util.ProjectUtils;

public class DeltaVisitor
implements IResourceDeltaVisitor {
    private String natureID;
    private IFileProcessor builder;
    private IProgressMonitor monitor;

    public DeltaVisitor(String natureID, IFileProcessor builder, IProgressMonitor monitor) {
        this.natureID = natureID;
        this.builder = builder;
        this.monitor = monitor;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            return project.isOpen() && ProjectUtils.getNature(project, this.natureID) != null;
        }
        if (resource instanceof IFolder) {
            return true;
        }
        if (resource instanceof IFile) {
            IPath path = resource.getFullPath();
            if (path.segmentCount() == 2 && path.lastSegment().equals(".classpath")) {
                this.builder.handleClassPassChanged(resource.getProject(), this.monitor);
            }
            if (FileUtils.isInJavaSourceFolder((IFile)resource)) {
                int kind = delta.getKind();
                IFile file = (IFile)resource;
                if (kind == 2) {
                    this.builder.handleFileRemoved(file, this.monitor);
                } else if (kind == 1) {
                    this.builder.handleFileAdded(file, false, this.monitor);
                } else if (kind == 4) {
                    this.builder.handleFileChanged(file, this.monitor);
                }
            }
        }
        return false;
    }
}

