/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.preference;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.seasar.kijimuna.core.Kijimuna;
import org.seasar.kijimuna.core.preference.IPreferences;

public class CascadePreferences
implements IPreferences {
    private IEclipsePreferences pref;
    private IEclipsePreferences defaultPref;
    private IEclipsePreferences basePref;

    public CascadePreferences(IEclipsePreferences pref, IEclipsePreferences defaultPref) {
        this(pref, defaultPref, null);
    }

    public CascadePreferences(IEclipsePreferences pref, IEclipsePreferences defaultPref, IEclipsePreferences basePref) {
        if (pref == null || defaultPref == null) {
            throw new IllegalArgumentException();
        }
        this.pref = pref;
        this.defaultPref = defaultPref;
        this.basePref = basePref;
    }

    public String getDefault(String key) {
        if (this.basePref == null) {
            return this.defaultPref.get(key, "");
        }
        return this.defaultPref.get(key, this.basePref.get(key, ""));
    }

    public boolean getDefaultBoolean(String key) {
        if (this.basePref == null) {
            return this.defaultPref.getBoolean(key, false);
        }
        return this.defaultPref.getBoolean(key, this.basePref.getBoolean(key, false));
    }

    public byte[] getDefaultByteArray(String key) {
        if (this.basePref == null) {
            return this.defaultPref.getByteArray(key, new byte[0]);
        }
        return this.defaultPref.getByteArray(key, this.basePref.getByteArray(key, new byte[0]));
    }

    public double getDefaultDouble(String key) {
        if (this.basePref == null) {
            return this.defaultPref.getDouble(key, 0.0);
        }
        return this.defaultPref.getDouble(key, this.basePref.getDouble(key, 0.0));
    }

    public float getDefaultFloat(String key) {
        if (this.basePref == null) {
            return this.defaultPref.getFloat(key, 0.0f);
        }
        return this.defaultPref.getFloat(key, this.basePref.getFloat(key, 0.0f));
    }

    public int getDefaultInt(String key) {
        if (this.basePref == null) {
            return this.defaultPref.getInt(key, 0);
        }
        return this.defaultPref.getInt(key, this.basePref.getInt(key, 0));
    }

    public long getDefaultLong(String key) {
        if (this.basePref == null) {
            return this.defaultPref.getLong(key, 0L);
        }
        return this.defaultPref.getLong(key, this.basePref.getLong(key, 0L));
    }

    public void putDefault(String key, String value) {
        this.defaultPref.put(key, value);
    }

    public void putDefaultBoolean(String key, boolean value) {
        this.defaultPref.putBoolean(key, value);
    }

    public void putDefaultByteArray(String key, byte[] value) {
        this.defaultPref.putByteArray(key, value);
    }

    public void putDefaultDouble(String key, double value) {
        this.defaultPref.putDouble(key, value);
    }

    public void putDefaultFloat(String key, float value) {
        this.defaultPref.putFloat(key, value);
    }

    public void putDefaultInt(String key, int value) {
        this.defaultPref.putInt(key, value);
    }

    public void putDefaultLong(String key, long value) {
        this.defaultPref.putLong(key, value);
    }

    public void removeDefault(String key) {
        this.defaultPref.remove(key);
    }

    public void clearDefault() {
        try {
            this.defaultPref.clear();
        }
        catch (BackingStoreException e) {
            Kijimuna.reportException((Exception)((Object)e));
        }
    }

    public String get(String key) {
        return this.pref.get(key, this.getDefault(key));
    }

    public boolean getBoolean(String key) {
        return this.pref.getBoolean(key, this.getDefaultBoolean(key));
    }

    public byte[] getByteArray(String key) {
        return this.pref.getByteArray(key, this.getDefaultByteArray(key));
    }

    public double getDouble(String key) {
        return this.pref.getDouble(key, this.getDefaultDouble(key));
    }

    public float getFloat(String key) {
        return this.pref.getFloat(key, this.getDefaultFloat(key));
    }

    public int getInt(String key) {
        return this.pref.getInt(key, this.getDefaultInt(key));
    }

    public long getLong(String key) {
        return this.pref.getLong(key, this.getDefaultLong(key));
    }

    public void put(String key, String value) {
        this.pref.put(key, value);
    }

    public void putBoolean(String key, boolean value) {
        this.pref.putBoolean(key, value);
    }

    public void putByteArray(String key, byte[] value) {
        this.pref.putByteArray(key, value);
    }

    public void putDouble(String key, double value) {
        this.pref.putDouble(key, value);
    }

    public void putFloat(String key, float value) {
        this.pref.putFloat(key, value);
    }

    public void putInt(String key, int value) {
        this.pref.putInt(key, value);
    }

    public void putLong(String key, long value) {
        this.pref.putLong(key, value);
    }

    public void remove(String key) {
        this.pref.remove(key);
    }

    public void clear() {
        try {
            this.pref.clear();
        }
        catch (BackingStoreException e) {
            Kijimuna.reportException((Exception)((Object)e));
        }
    }

    public void flash() {
        try {
            this.pref.flush();
            this.defaultPref.flush();
        }
        catch (BackingStoreException e) {
            Kijimuna.reportException((Exception)((Object)e));
        }
    }
}

