/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.dicon.validation;

import java.util.Iterator;
import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.dicon.IValidation;
import org.seasar.kijimuna.core.dicon.model.ArgElement;
import org.seasar.kijimuna.core.dicon.model.MethodElement;
import org.seasar.kijimuna.core.dicon.validation.MarkerSetting;
import org.seasar.kijimuna.core.parser.Element;
import org.seasar.kijimuna.core.util.StringUtils;

public class MethodValidation
implements IValidation,
ConstCore {
    public void validation(Element element) {
        if (element instanceof MethodElement) {
            this.validMethod((MethodElement)element);
        }
    }

    private void validMethod(MethodElement method) {
        String methodName = method.getMethodName();
        String el = method.getExpression();
        if (StringUtils.existValue(methodName)) {
            if (StringUtils.existValue(el)) {
                MarkerSetting.createDiconMarker("dicon.validation.MethodValidation.1", method);
            }
        } else {
            if (StringUtils.noneValue(el)) {
                MarkerSetting.createDiconMarker("dicon.validation.MethodValidation.2", method);
            }
            Iterator it = method.getArgList().iterator();
            while (it.hasNext()) {
                ArgElement arg = (ArgElement)it.next();
                MarkerSetting.createDiconMarker("dicon.validation.MethodValidation.3", arg);
            }
        }
    }
}

