/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.dicon.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.Kijimuna;
import org.seasar.kijimuna.core.dicon.DiconNature;
import org.seasar.kijimuna.core.parser.Element;
import org.seasar.kijimuna.core.preference.IPreferences;
import org.seasar.kijimuna.core.util.MarkerUtils;

public class MarkerSetting
implements ConstCore {
    private static String convertKey(int category) {
        return ConstCore.MARKER_SEVERITY_ALL[category];
    }

    private static boolean hasSetting(String[] settings, String key) {
        int i = 0;
        while (i < settings.length) {
            if (settings[i].equals(key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static int getCategoryID(String key) {
        if (MarkerSetting.hasSetting(ConstCore.MARKER_SET_XML_ERROR, key)) {
            return 0;
        }
        if (MarkerSetting.hasSetting(ConstCore.MARKER_SET_XML_WARNING, key)) {
            return 1;
        }
        if (MarkerSetting.hasSetting(ConstCore.MARKER_SET_NULL_INJECTION, key)) {
            return 2;
        }
        if (MarkerSetting.hasSetting(ConstCore.MARKER_SET_AUTO_INJECTION, key)) {
            return 3;
        }
        if (MarkerSetting.hasSetting(ConstCore.MARKER_SET_JAVA_FETAL, key)) {
            return 4;
        }
        if (MarkerSetting.hasSetting(ConstCore.MARKER_SET_DICON_FETAL, key)) {
            return 5;
        }
        if (MarkerSetting.hasSetting(ConstCore.MARKER_SET_DICON_PROBLEM, key)) {
            return 6;
        }
        return 7;
    }

    private static String getCategory(String key) {
        int category = MarkerSetting.getCategoryID(key);
        if (category == 7) {
            return "";
        }
        return MarkerSetting.convertKey(category);
    }

    private static int getSeveritySetting(IProject project, String key) {
        int category = MarkerSetting.getCategoryID(key);
        if (category == 7) {
            Kijimuna.reportInfo("unknown marker id [" + key + "]");
            return 3;
        }
        return MarkerSetting.getDiconMarkerPreference(project, category, false);
    }

    /*
     * WARNING - void declaration
     */
    public static void setDiconMarkerPreference(IProject project, int category, int severity) {
        void var3_3;
        IPreferences pref;
        if (project == null) {
            pref = Kijimuna.getPreferences();
        } else {
            DiconNature nature = DiconNature.getInstance(project);
            if (nature != null) {
                pref = nature.getPreferences();
            } else {
                return;
            }
        }
        String categoryKey = MarkerSetting.convertKey(category);
        var3_3.putInt(categoryKey, severity);
    }

    public static int getDiconMarkerPreference(IProject project, int category, boolean isDefault) {
        DiconNature nature;
        IPreferences pref = project == null ? Kijimuna.getPreferences() : ((nature = DiconNature.getInstance(project)) != null ? nature.getPreferences() : Kijimuna.getPreferences());
        String categoryKey = MarkerSetting.convertKey(category);
        if (isDefault) {
            return pref.getDefaultInt(categoryKey);
        }
        return pref.getInt(categoryKey);
    }

    public static void createDiconMarker(String id, Element element, String message) {
        IStorage storage = element.getStorage();
        if (storage != null && storage instanceof IFile) {
            IFile file = (IFile)storage;
            MarkerUtils.createMarker("org.seasar.kijimuna.core.marker.diconvalidation", MarkerSetting.getCategory(id), MarkerSetting.getSeveritySetting(file.getProject(), id), (IResource)file, element.getStartLine(), "[" + element.getElementName() + "] " + message);
        }
    }

    public static void createDiconMarker(String id, Element element, Object[] info) {
        MarkerSetting.createDiconMarker(id, element, Kijimuna.getResourceString(id, info));
    }

    public static void createDiconMarker(String id, Element element) {
        MarkerSetting.createDiconMarker(id, element, Kijimuna.getResourceString(id));
    }

    public static void createProjectMarker(String id, IProject project, String message) {
        MarkerUtils.createMarker("org.seasar.kijimuna.core.marker.diconvalidation", MarkerSetting.getCategory(id), MarkerSetting.getSeveritySetting(project, id), (IResource)project, 0, "[project] " + message);
    }
}

