/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.dicon.validation;

import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.dicon.IValidation;
import org.seasar.kijimuna.core.dicon.info.IApplyMethodInfo;
import org.seasar.kijimuna.core.dicon.info.IComponentNotFound;
import org.seasar.kijimuna.core.dicon.info.ITooManyRegisted;
import org.seasar.kijimuna.core.dicon.model.MethodElement;
import org.seasar.kijimuna.core.dicon.validation.MarkerSetting;
import org.seasar.kijimuna.core.parser.Element;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.rtti.IRttiMethodDesctiptor;
import org.seasar.kijimuna.core.util.ModelUtils;
import org.seasar.kijimuna.core.util.StringUtils;

public class AutoMethodInvoke
implements IValidation,
ConstCore {
    static /* synthetic */ Class class$0;

    public void validation(Element element) {
        if (element instanceof MethodElement) {
            try {
                this.invoke((MethodElement)element);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void invoke(MethodElement method) {
        IApplyMethodInfo info;
        String methodName = method.getMethodName();
        if (StringUtils.noneValue(methodName) || method.getArgList().size() > 0) {
            return;
        }
        IRtti component = ModelUtils.getComponentRtti(method);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.kijimuna.core.dicon.info.IApplyMethodInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((info = (IApplyMethodInfo)method.getAdapter(clazz)) != null) {
            IRttiMethodDesctiptor suitable = info.getAutoInjectedMethod();
            if (suitable != null) {
                IRtti[] suitableArgs = suitable.getArgs();
                IRtti[] injectedArgs = suitable.getValues();
                String display = ModelUtils.getMethodDisplay(suitable, true);
                if (injectedArgs != null) {
                    int i = 0;
                    while (i < suitableArgs.length) {
                        if (injectedArgs[i] instanceof IComponentNotFound) {
                            MarkerSetting.createDiconMarker("dicon.validation.AutoMethodInvoke.2", (Element)method, new Object[]{display, new Integer(i + 1)});
                        } else if (injectedArgs[i] instanceof ITooManyRegisted) {
                            MarkerSetting.createDiconMarker("dicon.validation.AutoMethodInvoke.4", (Element)method, new Object[]{display, new Integer(i + 1)});
                        } else {
                            MarkerSetting.createDiconMarker("dicon.validation.AutoMethodInvoke.1", (Element)method, new Object[]{display, new Integer(i + 1), ModelUtils.getInjectedElementName(injectedArgs[i])});
                        }
                        ++i;
                    }
                }
            } else {
                String display = ModelUtils.getMethodDisplay(component, methodName, new IRtti[0], true);
                MarkerSetting.createDiconMarker("dicon.validation.AutoMethodInvoke.3", (Element)method, new Object[]{display});
            }
        }
    }
}

