/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.dicon.tools;

import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.seasar.kijimuna.core.Kijimuna;
import org.seasar.kijimuna.core.dicon.info.IPointcut;
import org.seasar.kijimuna.core.dicon.model.AspectElement;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.rtti.IRttiMethodDesctiptor;
import org.seasar.kijimuna.core.util.ModelUtils;

public class Pointcut
implements IPointcut {
    private AspectElement aspect;
    private String regexp;
    private String message;
    private Pattern pattern;
    private transient IRttiMethodDesctiptor[] methods;
    private boolean autoApply;

    public Pointcut(AspectElement aspect, String regexp) {
        this.aspect = aspect;
        if (regexp != null) {
            this.regexp = regexp;
        } else {
            this.autoApply = true;
        }
        this.getPattern();
    }

    private Pattern getPattern() {
        if (this.pattern == null) {
            try {
                String r = this.regexp;
                if (this.autoApply) {
                    r = ".*";
                }
                this.pattern = Pattern.compile(r);
            }
            catch (PatternSyntaxException e) {
                this.message = e.getMessage();
            }
        }
        return this.pattern;
    }

    public IRttiMethodDesctiptor[] getApplyMethods() {
        if (this.methods == null) {
            this.methods = new IRttiMethodDesctiptor[0];
            if (this.autoApply) {
                IRtti rtti = ModelUtils.getComponentRtti(this.aspect);
                if (rtti != null) {
                    IRtti[] interfaces = rtti.getInterfaces();
                    Pattern p = this.getPattern();
                    TreeSet<IRttiMethodDesctiptor> set = new TreeSet<IRttiMethodDesctiptor>();
                    int i = 0;
                    while (i < interfaces.length) {
                        IRttiMethodDesctiptor[] desc = interfaces[i].getMethods(p);
                        int k = 0;
                        while (k < desc.length) {
                            IRttiMethodDesctiptor method = rtti.getMethod(desc[k].getMethodName(), desc[k].getArgs(), false);
                            set.add(method);
                            ++k;
                        }
                        ++i;
                    }
                    this.methods = set.toArray(new IRttiMethodDesctiptor[set.size()]);
                }
            } else {
                IRtti rtti;
                Pattern p = this.getPattern();
                if (p != null && (rtti = ModelUtils.getComponentRtti(this.aspect)) != null) {
                    this.methods = rtti.getMethods(p);
                }
            }
        }
        return this.methods;
    }

    public String getRegexp() {
        if (this.regexp != null) {
            return this.regexp;
        }
        return Kijimuna.getResourceString("dicon.tools.Pointcut.1");
    }

    public int compareTo(Object test) {
        if (test instanceof IPointcut) {
            IPointcut pointcut = (IPointcut)test;
            return this.getRegexp().compareTo(pointcut.getRegexp());
        }
        return 0;
    }

    public String getErrorMessage() {
        return this.message;
    }

    public boolean hasError() {
        return this.message != null;
    }
}

