/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.dicon;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.seasar.kijimuna.core.Kijimuna;
import org.seasar.kijimuna.core.dicon.DiconBuilder;
import org.seasar.kijimuna.core.dicon.DiconValidator;
import org.seasar.kijimuna.core.dicon.model.ContainerElement;
import org.seasar.kijimuna.core.project.IFileProcessor;
import org.seasar.kijimuna.core.project.IProjectRecordChangeListener;
import org.seasar.kijimuna.core.util.ProjectUtils;

public class ModelManager
implements Serializable {
    private transient IProject project;
    private String projectName;
    private Map containerMap = new HashMap();
    private Map relatedMap = new HashMap();
    private Set listeners = new HashSet();
    private transient IFileProcessor builder;
    private transient IFileProcessor validator;
    static /* synthetic */ Class class$0;

    public void setProjectName(String projectName) {
        this.projectName = projectName;
        this.builder = new DiconBuilder();
        this.validator = new DiconValidator();
    }

    public boolean isDirty() {
        return this.relatedMap.size() != 0;
    }

    private IProject getProject() {
        if (this.project == null) {
            this.project = ProjectUtils.getProject(this.projectName);
        }
        return this.project;
    }

    private void addRelatedMapItem(IStorage key, IStorage entry) {
        HashSet<String> item = null;
        String keyString = ProjectUtils.getPathString(key);
        item = (HashSet<String>)this.relatedMap.get(keyString);
        if (item == null) {
            item = new HashSet<String>(3);
        }
        if (entry != null) {
            item.add(ProjectUtils.getPathString(entry));
        }
        this.relatedMap.put(keyString, item);
    }

    public void validate(IProgressMonitor monitor) {
        this.validator.processProject(this.getProject(), monitor);
    }

    public void init(IProgressMonitor monitor) {
        this.builder.processProject(this.getProject(), monitor);
        this.validate(monitor);
    }

    public void addContainerAndRelatedFile(ContainerElement container, IStorage relatedFile) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IStorage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IStorage file = (IStorage)container.getAdapter(clazz);
        String keyString = ProjectUtils.getPathString(file);
        ModelManager modelManager = this;
        synchronized (modelManager) {
            this.containerMap.put(keyString, container);
            this.addRelatedMapItem(file, relatedFile);
        }
    }

    public ContainerElement getContainer(IStorage storage, IProgressMonitor monitor) {
        String keyString = ProjectUtils.getPathString(storage);
        ContainerElement ret = (ContainerElement)this.containerMap.get(keyString);
        if (ret == null) {
            this.builder.process(this.getProject(), storage, monitor);
            ret = (ContainerElement)this.containerMap.get(keyString);
        }
        return ret;
    }

    public ContainerElement[] getContainers(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask(Kijimuna.getResourceString("dicon.ModelManager.1"), this.relatedMap.size());
        }
        HashSet<ContainerElement> ret = new HashSet<ContainerElement>();
        Iterator it = this.relatedMap.keySet().iterator();
        while (it.hasNext()) {
            String keyString = (String)it.next();
            ret.add(this.getContainer(ProjectUtils.getStorage(this.getProject(), keyString), monitor));
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
        return ret.toArray(new ContainerElement[ret.size()]);
    }

    public IFile[] getRelatedFiles(IStorage depend, boolean infiniti) {
        HashSet<Object> ret = new HashSet<Object>();
        Iterator it = this.relatedMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Set item = (Set)entry.getValue();
            if (!item.contains(ProjectUtils.getPathString(depend))) continue;
            String keyString = (String)entry.getKey();
            IStorage storage = ProjectUtils.getStorage(this.getProject(), keyString);
            if (storage instanceof IFile) {
                ret.add(storage);
            }
            if (!infiniti) continue;
            IFile[] parents = this.getRelatedFiles(storage, true);
            int i = 0;
            while (i < parents.length) {
                ret.add(parents[i]);
                ++i;
            }
        }
        return ret.toArray(new IFile[ret.size()]);
    }

    public List getRootContainers(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask(Kijimuna.getResourceString("dicon.ModelManager.2"), this.relatedMap.size());
        }
        ArrayList<ContainerElement> ret = new ArrayList<ContainerElement>();
        Iterator it = this.relatedMap.keySet().iterator();
        while (it.hasNext()) {
            String keyString = (String)it.next();
            boolean isRoot = true;
            Iterator kt = this.relatedMap.entrySet().iterator();
            while (kt.hasNext()) {
                Set set = (Set)kt.next().getValue();
                if (!set.contains(keyString)) continue;
                isRoot = false;
                break;
            }
            if (isRoot) {
                ret.add(this.getContainer(ProjectUtils.getStorage(this.getProject(), keyString), monitor));
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
        return ret;
    }

    public void removeContainer(IStorage build) {
        String keyString = ProjectUtils.getPathString(build);
        this.containerMap.remove(keyString);
        this.relatedMap.remove(keyString);
    }

    public void clearContainer() {
        this.containerMap.clear();
        this.relatedMap.clear();
    }

    public void fireRecordChanged() {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            final IProjectRecordChangeListener listener = (IProjectRecordChangeListener)it.next();
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    listener.finishChanged();
                }
            };
            try {
                this.getProject().getWorkspace().run(runnable, null);
            }
            catch (CoreException e) {
                Kijimuna.reportException((Exception)((Object)e));
            }
        }
    }

    public void addRecordChangeListener(IProjectRecordChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeRecordChangeListener(IProjectRecordChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void prepareStoraging() {
        this.listeners.clear();
    }

    public void afterRestoring() {
        this.builder = new DiconBuilder();
        this.validator = new DiconValidator();
    }
}

