package test.org.seasar.flex.message;

import java.util.List;

import junit.framework.TestCase;

import org.seasar.flex.message.PatternTokenizer;

public class PatternTokenizerTest extends TestCase {

	public PatternTokenizerTest(String arg0) {
		super(arg0);
	}

	public void testNext() {
		String pattern = "aaa{0}bbb{1}";
		PatternTokenizer tokenizer = new PatternTokenizer(pattern);
		assertEquals("1", PatternTokenizer.STRING, tokenizer.next());
		assertEquals("2", "aaa", tokenizer.getToken());
		assertEquals("3", PatternTokenizer.VARIABLE, tokenizer.next());
		assertEquals("4", 0, tokenizer.getVarIndex());
		assertEquals("5", PatternTokenizer.STRING, tokenizer.next());
		assertEquals("6", "bbb", tokenizer.getToken());
		assertEquals("7", PatternTokenizer.VARIABLE, tokenizer.next());
		assertEquals("8", 1, tokenizer.getVarIndex());
		assertEquals("9", PatternTokenizer.EOF, tokenizer.next());
	}
	
	public void testNext2() {
		String pattern = "{0}bbb";
		PatternTokenizer tokenizer = new PatternTokenizer(pattern);
		assertEquals("1", PatternTokenizer.VARIABLE, tokenizer.next());
		assertEquals("2", 0, tokenizer.getVarIndex());
		assertEquals("3", PatternTokenizer.STRING, tokenizer.next());
		assertEquals("4", "bbb", tokenizer.getToken());
		assertEquals("5", PatternTokenizer.EOF, tokenizer.next());
	}
	
	public void testNext3() {
		String pattern = "bbb";
		PatternTokenizer tokenizer = new PatternTokenizer(pattern);
		assertEquals("1", PatternTokenizer.STRING, tokenizer.next());
		assertEquals("2", "bbb", tokenizer.getToken());
		assertEquals("3", PatternTokenizer.EOF, tokenizer.next());
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(PatternTokenizerTest.class);
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static class MyBean {
		private String aaa;
		private List bbb;
		/**
		 * @return Returns the aaa.
		 */
		public String getAaa() {
			return aaa;
		}
		/**
		 * @param aaa The aaa to set.
		 */
		public void setAaa(String aaa) {
			this.aaa = aaa;
		}
		/**
		 * @return Returns the bbb.
		 */
		public List getBbb() {
			return bbb;
		}
		/**
		 * @param bbb The bbb to set.
		 */
		public void setBbb(List bbb) {
			this.bbb = bbb;
		}
	}
}