/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.ui.dicon.provider.walker;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;
import org.seasar.kijimuna.core.dicon.model.ContainerElement;
import org.seasar.kijimuna.core.dicon.model.IncludeElement;
import org.seasar.kijimuna.core.parser.Element;
import org.seasar.kijimuna.core.util.ModelUtils;
import org.seasar.kijimuna.ui.ConstUI;
import org.seasar.kijimuna.ui.KijimunaUI;
import org.seasar.kijimuna.ui.dicon.provider.IContentWalker;
import org.seasar.kijimuna.ui.dicon.provider.IExternalContainer;
import org.seasar.kijimuna.ui.dicon.provider.IInternalContainer;
import org.seasar.kijimuna.ui.dicon.provider.property.IncludeProperty;

/**
 * @author Masataka Kurihara (Gluegent, Inc.)
 */
public class IncludeItem 
		implements IContentWalker, IExternalContainer, IInternalContainer, ConstUI {

    private IPropertySource source;
    private IContentWalker parent;
    private IncludeElement element;
    
    public IncludeItem(IncludeElement element, IContentWalker parent) {
        this.element = element;
    }
    
    public Element getElement() {
    	return element;
    }
    
    public ContainerElement getContainer() {
    	IProject project = (IProject)element.getAdapter(IProject.class);
    	IStorage storage = (IStorage)element.getAdapter(IStorage.class);
    	if((project != null) && (storage != null)) {
    		return ModelUtils.getContainer(project, storage);
    	} 
    	return null;
    }
    
    public ContainerElement getExternalContainer() {
        return element.getChildContainer();
    }
    
    public Object getParent() {
        return parent;
    }
    
    public Object[] getChildren() {
        return new Object[0];
    }
    
    public String getDisplayName() {
    	ContainerElement container = element.getChildContainer();
    	if(container != null) {
    		return container.getPath();
    	}
        return element.getPath();
    }
    
    public Image getImage() {
        return KijimunaUI.getImage(IMAGE_ICON_INCLUDE);
    }

    public Object getAdapter(Class adapter) {
        if(adapter.equals(IPropertySource.class)) {
            if(source == null) {
                source = new IncludeProperty(element);
            }
            return source;
        } else if(Element.class.equals(adapter)) {
            return element;
        }
        return element.getAdapter(adapter);
    }
}
