/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.ui.dicon.provider.property;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.seasar.kijimuna.core.dicon.IComponentKey;
import org.seasar.kijimuna.ui.KijimunaUI;

/**
 * @author Masataka Kurihara (Gluegent, Inc.)
 */
public class ComponentKeyRootProperty extends NullProperty {

    private static final String COUNT_ID = "key num";  
    private static final String TOOMANY_ID = "too many";  
    private static final String NORMAL_ID = "normal";  
    
    private static IPropertyDescriptor[] descriptors;
    
    static {
        descriptors = new IPropertyDescriptor[3];
        PropertyDescriptor d = new PropertyDescriptor(
		        COUNT_ID, KijimunaUI.getResourceString(
		                "dicon.provider.property.ComponentKeyRootProperty.1"));
        d.setCategory(KijimunaUI.getResourceString(
                "dicon.provider.property.ContentProperty.4"));
        descriptors[0] = d;        
        d = new PropertyDescriptor(
                TOOMANY_ID, KijimunaUI.getResourceString(
		                "dicon.provider.property.ComponentKeyRootProperty.2"));
        d.setCategory(KijimunaUI.getResourceString(
                "dicon.provider.property.ContentProperty.4"));
        descriptors[1] = d;        
        d = new PropertyDescriptor(
                NORMAL_ID, KijimunaUI.getResourceString(
		                "dicon.provider.property.ComponentKeyRootProperty.3"));
        d.setCategory(KijimunaUI.getResourceString(
                "dicon.provider.property.ContentProperty.4"));
        descriptors[2] = d;        
    }
    
    private IComponentKey[] keys;
    
    public ComponentKeyRootProperty(IComponentKey[] keys) {
        this.keys = keys;
    }

	public IPropertyDescriptor[] getPropertyDescriptors() {
		return descriptors;
	}
	
	private Integer countKey(boolean tooMany) {
	    int count = 0;
	    for(int i = 0; i < keys.length; i++) {
	        if(keys[i].isTooMany() == tooMany) {
	            count++;
	        }
	    }
	    return new Integer(count);
	}
	
	public Object getPropertyValue(Object id) {
		if(COUNT_ID.equals(id)) {
	        return new Integer(keys.length);
		} else if(TOOMANY_ID.equals(id)){
		    return countKey(true);
		} else if(NORMAL_ID.equals(id)) {
		    return countKey(false);
		}
		return null;
	}
    
    
}
