/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.ui.dicon.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.seasar.kijimuna.core.dicon.DiconNature;
import org.seasar.kijimuna.core.parser.Element;
import org.seasar.kijimuna.core.project.IProjectRecordChangeListener;
import org.seasar.kijimuna.core.util.ProjectUtils;
import org.seasar.kijimuna.ui.ConstUI;
import org.seasar.kijimuna.ui.dicon.provider.DiconContentProvider;
import org.seasar.kijimuna.ui.dicon.provider.DiconLabelProvider;
import org.seasar.kijimuna.ui.dicon.provider.IInternalContainer;
import org.seasar.kijimuna.ui.dicon.provider.walker.OutlineContent;
import org.seasar.kijimuna.ui.util.WorkbenchUtils;

/**
 * @author Masataka Kurihara (Gluegent, Inc.)
 */
public class DiconOutlinePage extends ContentOutlinePage
		implements IProjectRecordChangeListener, IDoubleClickListener, ConstUI {

    private IEditorPart part;
    private TreeViewer viewer;
    
    public DiconOutlinePage(IEditorPart part) {
        this.part = part;
    }

	private void setInput() {
	    IStorage storage = WorkbenchUtils.getInputResource(part);
	    if(storage != null) {
	        IProject project;
	        if(storage instanceof IFile) {
	            project = ((IFile)storage).getProject();
	        } else {
	            project = ProjectUtils.getProjectFromDiconStorage(storage);
	        }
	        if(project != null) {
	            viewer.setInput(new OutlineContent(project, storage));
	            return;
	        }
	    }
	    viewer.setInput(null);
	}

    private DiconNature getNature() {
        IStorage storage = WorkbenchUtils.getInputResource(part);
		if(storage != null) {
	        if(storage instanceof IFile) {
	            IProject project = ((IFile)storage).getProject();
	           	return DiconNature.getInstance(project);
	        }
		}
		return null;
    }
    
//    public void syncEditor(int lineNumber) {
//        OutlineContent content = (OutlineContent)viewer.getInput();
//        Object[] obj = content.getTopLevelItems();
//        if(obj[1] instanceof IContentWalker) {
//            IContentWalker walker = (IContentWalker)obj[1];
//            IContentWalker selected = findLine(walker, lineNumber);
//            if(selected != null) {
//	            ISelection selection = new StructuredSelection(selected);
//	            viewer.setSelection(selection, true);
//            }
//        }
//    }
//    
//    private IContentWalker findLine(IContentWalker walker, int lineNumber) {
//        Element element = (Element)walker.getAdapter(Element.class);
//        if(element != null) {
//	        int startLine = element.getStartLine();
//	        int endLine = element.getEndLine();
//	        if((startLine <= lineNumber) && (lineNumber <= endLine)) {
//	            return walker;
//	        }
//        }
//        Object[] obj = walker.getChildren();
//        for(int i = 0; i < obj.length; i++) {
//            if(obj[i] instanceof IContentWalker) {
//                return findLine((IContentWalker)obj[i], lineNumber);
//            }
//        }
//        return null;
//    }
    
    public void createControl(Composite parent) {
        super.createControl(parent);
        viewer = getTreeViewer();
        viewer.setContentProvider(new DiconContentProvider());
        viewer.setLabelProvider(new DiconLabelProvider());
        viewer.setAutoExpandLevel(5);
        viewer.addDoubleClickListener(this);
        setInput();
		DiconNature nature = getNature();
		if(nature != null) {
			nature.getModel().addRecordChangeListener(this);
		}
    }
    
	public void dispose() {
		DiconNature nature = getNature();
		if(nature != null) {
			nature.getModel().removeRecordChangeListener(this);
		}
		super.dispose();
	}
	
	public void finishChanged() {
	    final Control control = viewer.getTree();
	    Display display = control.getDisplay();
	    display.syncExec(new Runnable() {
	        public void run() {
	            if(control.isDisposed()) {
	                return;
	            } else {
	                setInput();
	            }
	        }
	    });
	}
	
	public void doubleClick(DoubleClickEvent event) {
		Object obj = WorkbenchUtils.getFirstSelectedElement(event.getSelection());
		WorkbenchUtils.showSource(part, obj);
	}
	
	public void selectionChanged(SelectionChangedEvent event) {
	    super.selectionChanged(event);
		Object obj = WorkbenchUtils.getFirstSelectedElement(event.getSelection());
        if(obj instanceof IInternalContainer) {
            Element element = ((IInternalContainer)obj).getElement();
            WorkbenchUtils.moveLine(part, element.getStartLine());
        }
	}

}
