/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.ui.dicon.editor;

import java.util.Iterator;
import java.util.TreeSet;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.seasar.kijimuna.ui.ConstUI;
import org.seasar.kijimuna.ui.KijimunaUI;

/**
 * @author Masataka Kurihara (Gluegent, Inc.)
 */
public class DiconEditor extends MultiPageEditorPart implements ConstUI {
   
	private IContentOutlinePage outline;
	
    private int addEditorPage(IEditorPart part, String title) {
        int ret = 0;
		try {
			ret = addPage(part, getEditorInput());
			setPageText(ret, title);
		} catch (PartInitException e) {
		    KijimunaUI.reportException(e);
		}
		return ret;
    }
    
    protected void createPages() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = 
            registry.getExtensionPoint(EXTENSION_DICONEDITOR);
        if(point != null) {
	        IExtension[] extensions = point.getExtensions();
	        TreeSet set = new TreeSet();
	        for(int i = 0; i < extensions.length; i++) {
	            IConfigurationElement conf = extensions[i].getConfigurationElements()[0];
	            try {
	                Object obj = conf.createExecutableExtension(
	                        EXTENSION_ATTR_CLASS);
	                if(obj instanceof IEditorPart) {
	                    IEditorPart editor = (IEditorPart)obj;
	                    String title = conf.getAttribute(
	                            EXTENSION_ATTR_NAME);
	                    int index = Integer.parseInt(conf.getAttribute(
	                            EXTENSION_ATTR_INDEX));
	                    set.add(new EditorPartItem(editor, title, index));
	                }
	            } catch (Exception e) {
	                KijimunaUI.reportException(e);
	            }
	        }
	        for(Iterator it = set.iterator(); it.hasNext();) {
	            EditorPartItem item = (EditorPartItem)it.next();
	            addEditorPage(item.getEditorPart(), item.getTitle());
	        }
        }
        setPartName(getEditorInput().getName());
        setTitleToolTip(getEditorInput().getToolTipText());
    }

    public void doSave(IProgressMonitor monitor) {
        for(int i = 0; i < getPageCount(); i++) {
		    IEditorPart editor = getEditor(i); 
	        if(editor.isSaveAsAllowed() && editor.isDirty()) {
	            editor.doSave(monitor);
	            break;
	        }
		}
     }

    public void doSaveAs() {
		for(int i = 0; i < getPageCount(); i++) {
		    IEditorPart editor = getEditor(i); 
	        if(editor.isSaveAsAllowed()) {
	            editor.doSaveAs();
	            IEditorInput input = editor.getEditorInput();
	    		setInput(input);
	    		setPartName(input.getName());
	            setTitleToolTip(getEditorInput().getToolTipText());
	    		return;
	        }
		}
    }

    public boolean isSaveAsAllowed() {
		for(int i = 0; i < getPageCount(); i++) {
		    IEditorPart editor = getEditor(i);
		    if(editor.isSaveAsAllowed()) {
		        return true;
		    }
		}
		return false;
    }
    
    public Object getAdapter(Class adapter) {
		if (adapter.equals(IContentOutlinePage.class)) {
	        if(outline == null) {
	        	outline = new DiconOutlinePage(this);
	        }
	        return outline;
		} else if(adapter.equals(IGotoMarker.class)) {
			for(int i = 0; i < getPageCount(); i++) {
			    IEditorPart editor = getEditor(i);
			    if(editor instanceof IGotoMarker) {
			        return editor;
			    } else {
			    	Object obj = editor.getAdapter(IGotoMarker.class);
			    	if(obj != null) {
			    		return obj;
			    	}
			    }
			}
			return null;
		}
        return super.getAdapter(adapter);
    }
}

