/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.ui;

import org.seasar.kijimuna.core.ConstCore;

/**
 * @author Masataka Kurihara (Gluegent,Inc.)
 */
public interface ConstUI extends ConstCore {

	public static final String ID_PLUGIN_UI = "org.seasar.kijimuna.ui";
	public static final String ID_EDITOR_DICON = ID_PLUGIN_UI + ".editor.dicon";
	
	public static final String PATH_RESOURCES = ID_PLUGIN_UI + ".resources";
	public static final String PATH_IMAGES = "/images/";

	public static final String EXTENSION_DICONEDITOR = "org.seasar.kijimuna.ui.diconeditorpart";
	public static final String EXTENSION_ATTR_CLASS = "class";
	public static final String EXTENSION_ATTR_NAME = "name";
	public static final String EXTENSION_ATTR_INDEX = "index";
	
	public static final String IMAGE_ICON_ARG = "icon/arg.gif";
	public static final String IMAGE_ICON_ARG_OGNL = "icon/arg_with_ognl.gif";
	public static final String IMAGE_ICON_ASPECT = "icon/aspect.gif";
	public static final String IMAGE_ICON_ASPECT_METHOD = "icon/aspect_method.gif";
	public static final String IMAGE_ICON_ASPECT_METHOD_NG = "icon/aspect_method_ng.gif";
	public static final String IMAGE_ICON_ASPECT_POINTCUT = "icon/aspect_pointcut.gif";
	public static final String IMAGE_ICON_ASPECT_REGEXP = "icon/aspect_regexp.gif";
	public static final String IMAGE_ICON_ASPECT_REGEXP_NG = "icon/aspect_regexp_ng.gif";
	public static final String IMAGE_ICON_ASPECT_OGNL= "icon/aspect_with_ognl.gif";
	public static final String IMAGE_ICON_AUTO_ARG = "icon/auto_arg.gif";
	public static final String IMAGE_ICON_AUTO_PROPERTY = "icon/auto_property.gif";
	public static final String IMAGE_ICON_COMPONENT = "icon/component.gif";
	public static final String IMAGE_ICON_COMPONENT_OGNL = "icon/component_with_ognl.gif";
	public static final String IMAGE_ICON_CONTAINER = "icon/container.gif";
	public static final String IMAGE_ICON_DESTROYMETHOD = "icon/destroyMethod.gif";
	public static final String IMAGE_ICON_DESTROYMETHOD_OGNL = "icon/destroyMethod_with_ognl.gif";
	public static final String IMAGE_ICON_INCLUDE = "icon/include.gif";
	public static final String IMAGE_ICON_INITMETHOD = "icon/initMethod.gif";
	public static final String IMAGE_ICON_INITMETHOD_OGNL = "icon/initMethod_with_ognl.gif";
	public static final String IMAGE_ICON_KEY_INTERFACE = "icon/key_interface.gif";
	public static final String IMAGE_ICON_KEY_INTERFACE_TOOMANY = "icon/key_interface_toomany.gif";
	public static final String IMAGE_ICON_KEY_ROOT = "icon/key_root.gif";
	public static final String IMAGE_ICON_KEY_STRING = "icon/key_string.gif";
	public static final String IMAGE_ICON_KEY_STRING_TOOMANY = "icon/key_string_toomany.gif";
	public static final String IMAGE_ICON_PARENT = "icon/parent.gif";
	public static final String IMAGE_ICON_PARENTS = "icon/parents.gif";
	public static final String IMAGE_ICON_PROPERTY = "icon/property.gif";
	public static final String IMAGE_ICON_PROPERTY_OGNL = "icon/property_with_ognl.gif";

	public static final String IMAGE_ICON_SEARCH_DICON = "icon/searce_dicon.gif";
	public static final String IMAGE_ICON_NEW_DICON = "icon/new_dicon.gif";
	public static final String IMAGE_NEW_DICON = "picture/wiz_new_dicon.gif";
	
	public static final String[] ECLIPSE_ENCODINGS = new String[] {
		"ISO-8859-1",
		"UTF-8",
		"UTF-16",
		"UTF-16BE",
		"UTF-16LE",
		"US-ASCII"
	};

}
